#include <amxmodx>
#include <fakemeta>
#include <ns>

new g_rTeamType[3]	//1 for marine, 2 for alien | has 3 parts so pev_team works without fudging([0] is empty)
new g_bEnabled = false

//-------------------------------------------------------------------------------------------------
//forwards

public plugin_modules()
{
	require_module("engine")
	require_module("fakemeta")
	require_module("ns")
}

public plugin_init()
{
	register_cvar("amx_levellimit", "1")
	register_cvar("lvll_max_marine", "8")
	register_cvar("lvll_max_alien", "6")
	
	if (!ns_is_combat())
		register_plugin("LevelLimit(OFF)", "1.0", "Darkns.xf")
	else
	{
		get_teams()
		g_bEnabled = true
		register_plugin("LevelLimit(ON)", "1.0", "Darkns.xf")
	}
}

public client_PreThink(id)
{
	if (!g_bEnabled)
		return PLUGIN_CONTINUE
	
	if (!get_cvar_num("amx_levellimit"))
		return PLUGIN_CONTINUE
	
	new eVisPlayer = id	//because...
	
	if ((pev(eVisPlayer, pev_iuser2) > 0))
		eVisPlayer = pev(eVisPlayer, pev_iuser2)
	
	new iTeam = pev(eVisPlayer, pev_team)
	if (!iTeam)
		return PLUGIN_CONTINUE
	
	new iMaxLevel = ((g_rTeamType[iTeam] == 1)?get_cvar_num("lvll_max_marine"):get_cvar_num("lvll_max_alien"))
	
	if ((iMaxLevel > 10) || (iMaxLevel < 1))
		return PLUGIN_CONTINUE
	
	new iLevel = get_level(eVisPlayer)
	if (iLevel < iMaxLevel)
		return PLUGIN_CONTINUE
	
	set_xp(eVisPlayer, genxp(iMaxLevel + 1) - 1)
	
	return PLUGIN_CONTINUE
}

//-------------------------------------------------------------------------------------------------
//stocks

stock get_teams()
{
	new iCommChairs = ns_get_build("team_command",0,0)
	if (iCommChairs == 0)
	{
		g_rTeamType[1] = 2
		g_rTeamType[2] = 2
	}
	else if (iCommChairs == 1)
	{
		g_rTeamType[1] = 1
		g_rTeamType[2] = 2
	}
	else
	{
		g_rTeamType[1] = 1
		g_rTeamType[2] = 1
	}
}

stock genxp(iLevel)
{
	iLevel--
	return (25 * iLevel) * (iLevel + 3) + 1
}

stock get_level(ePlayer)
	return get_xp_level(get_xp(ePlayer))

stock get_xp_level(iXP)
{
	if (!iXP)
		return 1
	return floatround((floatsqroot(225.0 + (4.0 * (iXP - 1))) - 15.0) / 10.0, floatround_floor) + 1
}

stock get_xp(ePlayer)
	return floatround(ns_get_exp(ePlayer))

stock set_xp(ePlayer, iXP)
	ns_set_exp(ePlayer, float(iXP))