/*
 *	Allows players to go above Level 10 (ad inf.) in Combat.
 *
 *	Credit:		Cheesy Peteza, for the extralevels plugin, of which this is derived from.
 *
 *	Note: 		Set the point max one less than the level max. IE: at when the player has gotten 12 points, he is level 13.
 *			To get the same effect as capping the level, subtract one: max level of 12 -> max points 11.
 *
 *	Commands:	None
 *
 *	Cvars:		amx_inflevel		Whether or not to have extra levels.(0(off) or 1(on))
 *			ilvl_xp_lvlinc		How much xp is added to the xp requirement for extra levels	
 *			ilvl_xp_baseinc		How much to start requiring at as a base...
 *			ilvl_maxlevelmarine	Set to the highest level you want to allow for marines.(default 10000)
 *			ilvl_maxlevelalien	Set to the highest level you want to allow for aliens.(default 10000)
 *			ilvl_maxpointsmarine	Set to the highest amount of points you want to allow for marines.(default 20)
 *			ilvl_maxpointsalien	Set to the highest amount of points you want to allow for aliens.(default 19)
 *			ilvl_capxp		Whether or not to cap the xp at max level or let it keep climbing.(0(infinite xp) or 1(capped at max level's xp))
 *			ilvl_extlvinfo		Whether or not to display extra xp info.(0(off) or 1(on))
 *			ilvl_latejoin		Whether or not to give latejoin xp.(0(off) or 1(on))
 *			ilvl_latepercent	How many levels behind the rest of the team they need to be to get latejoin xp
 *			ilvl_latemaxlvls	Maximum ammount of levels to give for lategive (default 5)
 *			ilvl_slowcheckdelay	How many seconds between checking for players who have fallen behind the average team level and need a boost (default 30)
 *			ilvl_titles		Whether or not to show custom titles for levels 10 and above.(0(off) or 1(on))
 *
 *	Author:		Darkns
 *	Date:		23-March-2005
 */

#include <amxmodx>
#include <amxmisc>	//for getting the configs dir...
#include <engine>
#include <ns>
#include <fakemeta>

#define HUD_CHANNEL		4
#define DLVLINC			50		//DO NOT CHANGE! This is for levels 1-10
#define LEVELSOUND_A		"misc/a-levelup.wav"
#define LEVELSOUND_M		"misc/levelup.wav"
#define SOUND_CHANNEL		CHAN_ITEM	//from HLSDK
#define SOUND_VOL		VOL_NORM
#define SOUND_ATT		ATTN_NONE
#define SOUND_PITCH		PITCH_NORM
#define TITLEFILE_A		"atitles.ini"
#define TITLEFILE_M		"mtitles.ini"
#define SLOWXPOFFSET		31415926	//pai!
#define INT_MAXSIZE		2147483647	//anti-overflow
//colors
#define ARED			160
#define AGREEN			100
#define ABLUE			0
#define MRED			0
#define MGREEN			75
#define MBLUE			100

//If you added titles, set this to the number of titles you have
#define MAX_ATITLES		50	//for alien
#define MAX_MTITLES		50	//for marine

//new g_maxplrs
new g_lastxp[33], g_extrapts[33]
new g_title[33][32]	//[index][sztitle]
new bool:g_wasblank[33], bool:g_skipupdate[33]	//to cut down on 'stuff'
new g_teamtype[3]	//1 for marine, 2 for alien | has 3 parts so pev_team works without fudging([0] is empty)
new g_lvlinc
new g_baseinc
new g_atitlepath[128]
new g_mtitlepath[128]
new g_atitles[MAX_ATITLES][32]
new g_mtitles[MAX_MTITLES][32]
new g_iMaxLevel		//so we don't overflow in the event someone gets to 9268 with over 2 billion xp, 9267 is normal max

public plugin_precache()
{
	precache_sound(LEVELSOUND_A)
	precache_sound(LEVELSOUND_M)
}

public plugin_modules()
{
	require_module("engine")
	require_module("ns")
	require_module("fakemeta")
}

public plugin_init()
{
	register_cvar("amx_inflevel", "1")
	register_cvar("ilvl_xp_lvlinc", "50")
	register_cvar("ilvl_xp_baseinc", "0")
	register_cvar("ilvl_maxlevelmarine", "10000")
	register_cvar("ilvl_maxlevelalien", "10000")
	register_cvar("ilvl_maxpointsmarine", "9999")
	register_cvar("ilvl_maxpointsalien", "9999")
	register_cvar("ilvl_capxp", "1")			//caps the xp at max, or lets it keep climbing
	register_cvar("ilvl_extlvinfo", "1")
	register_cvar("ilvl_latejoin", "1")
	register_cvar("ilvl_latepercent", "75")
	register_cvar("ilvl_latemaxlvls", "5")
	register_cvar("ilvl_slowcheckdelay", "30")
	register_cvar("ilvl_titles", "1")
	
	if (!ns_is_combat())
	{
		register_plugin("Inflvl(OFF)", "4.00", "Darkns.xf")
	}
	else
	{
		register_plugin("Inflvl(ON)", "4.00", "Darkns.xf")
		
//		g_maxplrs = get_maxplayers()
		get_teams()
		get_maxxp()
		load_titles()
		
		register_event("DeathMsg", "checklevelsdelay", "a")		// Test for XP after a player is killed
		
		if (get_cvar_num("amx_inflevel"))
			set_task(0.50, "xpcontrol",_,_,_,"b")
		new checkdelay = get_cvar_num("ilvl_slowcheckdelay")
		new Float:fcd = float(checkdelay)
		if (get_cvar_num("ilvl_latejoin") && get_cvar_num("ilvl_slowcheckdelay"))
			set_task(fcd, "slowxpcheck",SLOWXPOFFSET,_,_,"b")
		
		g_lvlinc = get_cvar_num("ilvl_xp_lvlinc")
		g_baseinc = get_cvar_num("ilvl_xp_baseinc")
		
		new cdir[112]		//128 - 16 (filenames are 11...)
		get_configsdir(cdir,111)
		format(g_atitlepath, 127, "%s/%s", cdir, TITLEFILE_A)
		format(g_mtitlepath, 127, "%s/%s", cdir, TITLEFILE_M)
	}
}

public client_spawn(id)
{
	if (!ns_is_combat())
		return PLUGIN_CONTINUE
	new team = pev(id, pev_team)
	if (team != 0)
	{
		new arg[2]
		arg[0] = id
		arg[1] = team
		set_task(0.1,"ctxptask",_,arg,2)
	}
	g_skipupdate[id] = false
	return PLUGIN_CONTINUE
}

public client_changeteam(id,newteam,oldteam)
{
	g_lastxp[id] = 0
	g_extrapts[id] = 0
	if ((get_cvar_num("ilvl_latejoin") && ns_is_combat()) && (newteam != 0))
	{
		new arg[2]
		arg[0] = id
		arg[1] = newteam
		set_task(0.1,"ctxptask",_,arg,2)	//make sure they all the way on team to doo eet...
	}
	//else who cares?
	return PLUGIN_CONTINUE
}

public ctxptask(arg[2])	//Change Team eXPerience TASK
{
	new id = arg[0]
	new team = arg[1]
	givelate(id, team)
	return PLUGIN_CONTINUE
}

public slowxpcheck()
{
	if (!get_cvar_num("ilvl_latejoin") || !get_cvar_num("ilvl_slowcheckdelay"))
	{
		remove_task(SLOWXPOFFSET)
		return PLUGIN_CONTINUE
	}
	for (new id = 1; id <= g_maxplrs; id++)
	{
		if (!ns_is_combat() || !is_user_connected(id))
			return PLUGIN_CONTINUE
		new team = pev(id, pev_team)
		if (team != 0)
			givelate(id, team)
	}
	return PLUGIN_CONTINUE
}

public 

public xpcontrol()
{
	//CHECK LEVELS
	if ( (!get_cvar_num("ilvl_maxlevelmarine")) ||
	     (!get_cvar_num("ilvl_maxlevelalien")) ||
	     (!get_cvar_num("ilvl_maxpointsmarine")) ||
	     (!get_cvar_num("ilvl_maxpointsalien")) )
		return PLUGIN_CONTINUE
	
	new vid		//visual id, who's xp you're checking...
	new bool:self
	for (new id = 1; id <= g_maxplrs; id++)
	{
		if (!is_user_connected(id))					//if they're not connected, skip
			continue
		
		vid = id
		
		if ((pev(id, pev_iuser2) > 0))
			vid = pev(id, pev_iuser2)				//this will handle people specing/rr
		
		if (!is_user_connected(vid))					//if they're not connected, skip
			continue
		
		new vteam = pev(vid, pev_team)
		
		if (vteam == 0)
		{
			if (g_wasblank[id] == true)
				continue
			set_hudmessage(0, 0, 0, -1.0, 0.89, 0, 0.0, 3600.0, 0.0, 0.0, HUD_CHANNEL)
			show_hudmessage(id, " ")
			g_wasblank[id] = true
			continue
		}
		else
			g_wasblank[id] = false
		
		if (vid == id)
			self = true
		else
			self = false
		
		new vlevel = get_level(vid)					//their level
		
		new maxlevel							//for team specific level limits
		switch (g_teamtype[vteam])
		{
			case 1:
				maxlevel = get_cvar_num("ilvl_maxlevelmarine")
			case 2:
				maxlevel = get_cvar_num("ilvl_maxlevelalien")
		}
		new maxpoints							//for team specific point limits
		switch (g_teamtype[vteam])
		{
			case 1:
				maxpoints = get_cvar_num("ilvl_maxpointsmarine")
			case 2:
				maxpoints = get_cvar_num("ilvl_maxpointsalien")
		}
		
		if (maxlevel < g_maxlevel)
			maxlevel = g_maxlevel
		
		if (vlevel > maxlevel)							//if they have too many levels
			vlevel = maxlevel						//set it back
		
		new vxp = get_xp(vid)
		
		if (self)
		{
			new usedpoints = get_pts(vid)
			new lastxplvl = get_xp_level(g_lastxp[vid])
			lastxplvl = (lastxplvl >= 10)?lastxplvl:10
			if ( (vlevel > lastxplvl) && (vlevel > 10) )	//they have one more level then their last xp shows
			{
				if (g_teamtype[vteam] == 1)	//marine
					emit_sound(vid, SOUND_CHANNEL, LEVELSOUND_M, SOUND_VOL, SOUND_ATT, 0, SOUND_PITCH)
				else if (!(ns_get_mask(id) & MASK_SILENCE))
					emit_sound(vid, SOUND_CHANNEL, LEVELSOUND_A, SOUND_VOL, SOUND_ATT, 0, SOUND_PITCH)
				
				for (new i = lastxplvl + 1; i <= vlevel; i++)
				{
					if ((i-1) <= maxpoints)
						usedpoints--
				}
			}
			
			usedpoints -= g_extrapts[vid]
			g_extrapts[vid] = 0
			if (usedpoints < 0)
			{
				g_extrapts[vid] = 0 - usedpoints
				usedpoints = 0
			}
			
			set_pts(vid, usedpoints)
			if ((g_skipupdate[id]) && (vxp == g_lastxp[vid]))
				continue
			
			if (vxp == g_lastxp[vid])	//was commented so that if someone somehow managed not to gain one xp in an hour...their menu goes away...why?
				g_skipupdate[id] = true
			else
				g_skipupdate[id] = false
			
			g_lastxp[vid] = vxp
		}
		new lvl10xp = genxp(10)
		if (vxp < lvl10xp)
		{
			set_hudmessage(0, 0, 0, -1.0, 0.89, 0, 0.0, 3600.0, 0.0, 0.0, HUD_CHANNEL)
			show_hudmessage(id, " ")
			g_wasblank[id] = true
			continue
		}
		new is_marine = (g_teamtype[pev(vid, pev_team)] == 1)
		
		new showtitles = get_cvar_num("ilvl_titles")
		if (showtitles)
		{
			if (self)
			{
				new titlenum = vlevel - 10
				new maxtitle = is_marine?MAX_MTITLES:MAX_ATITLES
				maxtitle--
				if (titlenum > maxtitle)
					titlenum = maxtitle
				
				//not reading from an external file anymore, so we can just do this...everytime...
				g_title[vid] = is_marine?g_mtitles[titlenum]:g_atitles[titlenum]
			}
			
			if (equali(g_title[vid], ""))
				showtitles = 0
		}
		
		set_hudmessage(is_marine?MRED:ARED, is_marine?MGREEN:AGREEN, is_marine?MBLUE:ABLUE, -1.0, is_user_alive(id)?0.89:0.82, 0, 0.0, 3600.0, 0.0, 0.0, HUD_CHANNEL)
		
		new dbg = get_cvar_num("ilvl_extlvinfo")
		
		if (vlevel == maxlevel)
		{
			if (get_cvar_num("ilvl_capxp") == 1)
				vxp = genxp(maxlevel - 1)
			if (showtitles)
			{
				if (dbg)
					show_hudmessage(id, "Level %d %s: %d XP", vlevel, g_title[vid], vxp)
				else
					show_hudmessage(id, "Level %d %s", vlevel, g_title[vid])
			}
			else
			{
				if (dbg)
					show_hudmessage(id, "Level %d: %d XP", vlevel, vxp)
				else
					show_hudmessage(id, "Level %d", vlevel)
			}
		}
		else
		{
			new nextlevelxp = get_next_levelxp(vid)
			new lastlevelxp = get_last_levelxp(vid)
			new percentage = ((vxp-lastlevelxp) * 100) / (nextlevelxp-lastlevelxp)
			if (showtitles)
			{
				if (dbg)
					show_hudmessage(id, "Level %d %s: %d XP of %d (%d%)", vlevel, g_title[vid], vxp, nextlevelxp, percentage)
				else
					show_hudmessage(id, "Level %d %s: %d%", vlevel, g_title[vid], percentage)
			}
			else
			{
				if (dbg)
					show_hudmessage(id, "Level %d: %d XP of %d (%d%)", vlevel, vxp, nextlevelxp, percentage)
				else
					show_hudmessage(id, "Level %d: %d%", vlevel, percentage)
			}
		}
	}
	return PLUGIN_CONTINUE
}

public checklevelsdelay()
	set_task(0.1, "xpcontrol")	// Player died, XP must have changed, check everyone immediately.

public givelate(id, team)
{
	if (!get_cvar_num("ilvl_latejoin"))
		return PLUGIN_CONTINUE

	new teamlvls
	new teamplrs
	for (new i = 1; i <= g_maxplrs; i++)
	{
		if (!is_user_connected(i))
			continue
		if (i == id)
			continue
		if (pev(i, pev_team) == team)
		{
			teamlvls += get_level(i)
			teamplrs++
		}
	}
	if (teamplrs == 0)
		return PLUGIN_CONTINUE	//divide by zero escape
	new atlvl = teamlvls / teamplrs	//Average Team LeVeL
	new idlvl = get_level(id)
	new lvlrat = (idlvl * 100) / atlvl
	if ((idlvl >= atlvl) || (idlvl >= get_cvar_num("ilvl_latemaxlvls")))
		return PLUGIN_CONTINUE
	
	if (lvlrat <= get_cvar_num("ilvl_latepercent"))
	{
		new maxlatelvl = get_cvar_num("ilvl_latemaxlvls")
		if (atlvl > maxlatelvl)
			atlvl = maxlatelvl
		new newxp = genxp(atlvl)
		
		newxp++		//otherwise, this gives *nearly* what's needed for the level
		ns_set_exp(id, float(newxp))
		client_print(id, print_chat, "[AMXX] You have been given an experience boost because you were too far behind your team.")
	}
	return PLUGIN_CONTINUE
}

stock get_teams()
{
	new commcount = ns_get_build("team_command",0,0)
	if (commcount == 0)
	{
		g_teamtype[1] = 2
		g_teamtype[2] = 2
	}
	else if (commcount == 1)
	{
		g_teamtype[1] = 1
		g_teamtype[2] = 2
	}
	else
	{
		g_teamtype[1] = 1
		g_teamtype[2] = 1
	}
}

stock get_maxxp()
	g_iMaxLevel = get_xp_level(INT_MAXSIZE) - 1


stock load_titles()
{
	new path[128], maxtitles
	path = g_atitlepath//g_mtitlepath
	maxtitles = MAX_ATITLES
	if (file_exists(path))
	{
		new maxlines = file_size(path, 1)
		if (maxlines > maxtitles)
			maxlines = maxtitles
		maxlines--	//otherwise gives the _last_ line (i.e. blank), and this is zero-based, thus last = count - 1
		
		new txtlen	//yay junk vars!
		for (new curline = 0; curline <= maxlines; curline++)
			read_file(path, curline,g_atitles[curline],31,txtlen)
	}
	else
		server_print("[InfLevels] - error accessing alien titles at %s", path)
	
	path = g_mtitlepath
	maxtitles = MAX_MTITLES
	if (file_exists(path))
	{
		new maxlines = file_size(path, 1)
		if (maxlines > maxtitles)
			maxlines = maxtitles
		maxlines--	//otherwise gives the _last_ line (i.e. blank), and this is zero-based, thus last = count - 1
		
		new txtlen	//yay junk vars!
		for (new curline = 0; curline <= maxlines; curline++)
			read_file(path, curline,g_mtitles[curline],31,txtlen)
	}
	else
		server_print("[InfLevels] - error accessing marine titles at %s", path)
}

stock genxp(iLevel)
{
	iLevel--
	return (25 * iLevel) * (iLevel + 3) + 1
}

stock get_level(ePlayer)
	return get_xp_level(get_xp(ePlayer))

stock get_xp_level(iXP)
	return floatround((floatsqroot(225.0 + (4.0 * (iXP - 1))) - 15.0) / 10.0 ,floatround_floor) + 1

stock get_next_levelxp(ePlayer)
	return genxp(get_level(ePlayer) + 1)

stock get_last_levelxp(index)
	return genxp(get_level(ePlayer))

stock get_xp(ePlayer)
	return floatround(ns_get_exp(ePlayer))

stock get_pts(ePlayer)
	return ns_get_points(ePlayer)

stock set_pts(ePlayer, iPoints)
	ns_set_points(ePlayer,iPoints)

