/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;

public class PathUtils {
    private PathUtils() {
    }

    public static String getName(Path path) {
        return path.getFileName().toString();
    }

    public static String getBaseName(Path path) {
        return FilenameUtils.getBaseName(path.getFileName().toString());
    }

    public static String getExtension(Path path) {
        return FilenameUtils.getExtension(path.getFileName().toString());
    }

    public static Path setExtension(Path path, String ext) {
        String name = path.getFileName().toString();
        name = FilenameUtils.removeExtension(name);
        if (ext == null) {
            return path.resolveSibling(name);
        }
        return path.resolveSibling(name + '.' + ext);
    }

    public static Path removeExtension(Path path) {
        return PathUtils.setExtension(path, null);
    }

    public static Path append(Path path, String ext) {
        return path.resolveSibling(path.getFileName().toString() + ext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirectoryEmpty(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
            boolean bl = !ds.iterator().hasNext();
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void deleteQuietly(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Path getCodeSourceLocation(Class clazz) {
        try {
            return Paths.get(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }
}

