/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.channel;

import info.ata4.io.buffer.ByteBufferUtils;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ChannelUtils {
    public static boolean isReadable(Channel c) {
        if (!(c instanceof ReadableByteChannel)) {
            return false;
        }
        try {
            ReadableByteChannel rbc = (ReadableByteChannel)c;
            rbc.read(ByteBufferUtils.EMPTY);
            return true;
        }
        catch (NonReadableChannelException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new RuntimeException("Broken channel", ex);
        }
    }

    public static boolean isWritable(Channel c) {
        if (!(c instanceof WritableByteChannel)) {
            return false;
        }
        try {
            WritableByteChannel wbc = (WritableByteChannel)c;
            wbc.write(ByteBufferUtils.EMPTY);
            return true;
        }
        catch (NonWritableChannelException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new RuntimeException("Broken channel", ex);
        }
    }

    private ChannelUtils() {
    }
}

