/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.channel;

import info.ata4.io.buffer.source.SeekableByteChannelSource;
import info.ata4.io.channel.BufferedChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class BufferedSeekableByteChannel
extends BufferedChannel<SeekableByteChannel, SeekableByteChannelSource>
implements SeekableByteChannel {
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;

    public BufferedSeekableByteChannel(SeekableByteChannel chan, int bufferSize) {
        super(chan, new SeekableByteChannelSource(ByteBuffer.allocateDirect(bufferSize), chan));
    }

    public BufferedSeekableByteChannel(SeekableByteChannel chan) {
        this(chan, 0x100000);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return ((SeekableByteChannelSource)this.buf).read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return ((SeekableByteChannelSource)this.buf).write(src);
    }

    @Override
    public long position() throws IOException {
        return ((SeekableByteChannelSource)this.buf).position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        ((SeekableByteChannelSource)this.buf).position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return ((SeekableByteChannelSource)this.buf).size();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        ((SeekableByteChannelSource)this.buf).truncate(size);
        return this;
    }
}

