/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer.source;

import info.ata4.io.buffer.ByteBufferChannel;
import info.ata4.io.buffer.source.BufferedSource;
import info.ata4.io.buffer.source.NonWritableSourceException;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferSource
implements BufferedSource {
    private final ByteBuffer buf;
    private final ByteBufferChannel chanBuf;

    public ByteBufferSource(ByteBuffer buffer) {
        this.buf = buffer;
        this.chanBuf = new ByteBufferChannel(buffer);
    }

    @Override
    public void position(long newPos) throws IOException {
        if (newPos < 0L || newPos > (long)this.buf.limit()) {
            throw new IllegalArgumentException();
        }
        this.buf.position((int)newPos);
    }

    @Override
    public long position() throws IOException {
        return this.buf.position();
    }

    @Override
    public long size() throws IOException {
        return this.buf.limit();
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public void order(ByteOrder order) {
        this.buf.order(order);
    }

    @Override
    public int bufferSize() {
        return this.buf.capacity();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return !this.buf.isReadOnly();
    }

    @Override
    public boolean canGrow() {
        return false;
    }

    @Override
    public boolean canSeek() {
        return true;
    }

    @Override
    public void flush() {
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.chanBuf.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.canWrite()) {
            throw new NonWritableSourceException();
        }
        return this.chanBuf.write(src);
    }

    @Override
    public ByteBuffer requestRead(int required) throws EOFException, IOException {
        if (this.buf.remaining() < required) {
            throw new EOFException();
        }
        return this.buf;
    }

    @Override
    public ByteBuffer requestWrite(int required) throws EOFException, IOException {
        if (!this.canWrite()) {
            throw new NonWritableSourceException();
        }
        return this.requestRead(required);
    }

    @Override
    public void close() throws IOException {
    }
}

