/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ByteBufferUtils {
    public static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private static final int DIRECT_THRESHOLD = 10240;

    private ByteBufferUtils() {
    }

    private static int truncateLength(FileChannel fc, int length) throws IOException {
        return (int)Math.min(length > 0 ? (long)length : fc.size(), Integer.MAX_VALUE);
    }

    public static ByteBuffer allocate(int size) {
        if (size > 10240) {
            return ByteBuffer.allocateDirect(size);
        }
        try {
            return ByteBuffer.allocate(size);
        }
        catch (OutOfMemoryError ex) {
            return ByteBuffer.allocateDirect(size);
        }
    }

    public static ShortBuffer allocateDirectShort(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 2);
        bb.order(ByteOrder.nativeOrder());
        return bb.asShortBuffer();
    }

    public static CharBuffer allocateDirectChar(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 2);
        bb.order(ByteOrder.nativeOrder());
        return bb.asCharBuffer();
    }

    public static IntBuffer allocateDirectInt(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 4);
        bb.order(ByteOrder.nativeOrder());
        return bb.asIntBuffer();
    }

    public static LongBuffer allocateDirectLong(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 8);
        bb.order(ByteOrder.nativeOrder());
        return bb.asLongBuffer();
    }

    public static FloatBuffer allocateDirectFloat(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 4);
        bb.order(ByteOrder.nativeOrder());
        return bb.asFloatBuffer();
    }

    public static DoubleBuffer allocateDirectDouble(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 8);
        bb.order(ByteOrder.nativeOrder());
        return bb.asDoubleBuffer();
    }

    public static ByteBuffer load(Path path, int offset, int length) throws IOException {
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);){
            int size = ByteBufferUtils.truncateLength(fc, length);
            ByteBuffer bb = ByteBufferUtils.allocate(size);
            fc.position(offset);
            fc.read(bb);
            bb.flip();
            ByteBuffer byteBuffer = bb;
            return byteBuffer;
        }
    }

    public static ByteBuffer load(Path path) throws IOException {
        return ByteBufferUtils.load(path, 0, -1);
    }

    public static ByteBuffer load(List<Path> paths) throws IOException {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        for (Path path : paths) {
            bbs.add(ByteBufferUtils.openReadOnly(path));
        }
        return ByteBufferUtils.concat(bbs);
    }

    public static void save(Path path, ByteBuffer bb) throws IOException {
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            fc.truncate(bb.remaining());
            fc.write(bb);
        }
    }

    public static MappedByteBuffer openReadOnly(Path path, int offset, int length) throws IOException {
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);){
            MappedByteBuffer mappedByteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, offset, ByteBufferUtils.truncateLength(fc, length));
            return mappedByteBuffer;
        }
    }

    public static MappedByteBuffer openReadOnly(Path path) throws IOException {
        return ByteBufferUtils.openReadOnly(path, 0, -1);
    }

    public static MappedByteBuffer openReadWrite(Path path, int offset, int length) throws IOException {
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            MappedByteBuffer mappedByteBuffer = fc.map(FileChannel.MapMode.READ_WRITE, offset, ByteBufferUtils.truncateLength(fc, length));
            return mappedByteBuffer;
        }
    }

    public static MappedByteBuffer openReadWrite(Path path) throws IOException {
        return ByteBufferUtils.openReadWrite(path, 0, -1);
    }

    public static ByteBuffer getSlice(ByteBuffer bb, int offset, int length) {
        if (length == 0) {
            return EMPTY;
        }
        ByteOrder order = bb.order();
        bb = bb.duplicate();
        bb.position(offset);
        if (length > 0) {
            bb.limit(offset + length);
        }
        ByteBuffer bbSlice = bb.slice();
        bbSlice.order(order);
        return bbSlice;
    }

    public static ByteBuffer getSlice(ByteBuffer bb, int offset) {
        return ByteBufferUtils.getSlice(bb, offset, -1);
    }

    public static ByteBuffer concat(List<ByteBuffer> bbs) {
        long length = 0L;
        for (ByteBuffer bb : bbs) {
            bb.rewind();
            length += (long)bb.remaining();
        }
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Buffers are too large for concatenation");
        }
        if (length == 0L) {
            return EMPTY;
        }
        ByteBuffer bbNew = ByteBuffer.allocateDirect((int)length);
        for (ByteBuffer bb : bbs) {
            bb.rewind();
            bbNew.put(bb);
        }
        bbNew.rewind();
        return bbNew;
    }

    public static ByteBuffer concat(ByteBuffer ... bb) {
        return ByteBufferUtils.concat(Arrays.asList(bb));
    }

    public static ByteBuffer copy(ByteBuffer bb, boolean forceDirect) {
        int capacity = bb.limit();
        int pos = bb.position();
        ByteOrder order = bb.order();
        ByteBuffer copy = bb.isDirect() || forceDirect ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        bb.rewind();
        copy.order(order);
        copy.put(bb);
        copy.position(pos);
        bb.position(pos);
        return copy;
    }

    public static ByteBuffer copy(ByteBuffer bb) {
        return ByteBufferUtils.copy(bb, false);
    }

    public static int transfer(ByteBuffer src, ByteBuffer dst) {
        int numBytes = Math.min(src.remaining(), dst.remaining());
        if (numBytes > 0) {
            int oldLimit = src.limit();
            src.limit(src.position() + numBytes);
            dst.put(src);
            src.limit(oldLimit);
        }
        return numBytes;
    }

    public static boolean isEmpty(ByteBuffer bb) {
        return bb == null || bb.capacity() == 0;
    }
}

