/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.DataWriter;
import info.ata4.io.buffer.source.ByteBufferSource;
import info.ata4.io.buffer.source.SeekableByteChannelSource;
import info.ata4.io.buffer.source.WritableByteChannelSource;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class DataWriters {
    public static DataWriter forByteBuffer(ByteBuffer bb) {
        return new DataWriter(new ByteBufferSource(bb));
    }

    public static DataWriter forWritableByteChannel(WritableByteChannel chan) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(262144);
        WritableByteChannelSource buf = new WritableByteChannelSource(bb, chan);
        return new DataWriter(buf);
    }

    public static DataWriter forSeekableByteChannel(SeekableByteChannel chan) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(65536);
        SeekableByteChannelSource buf = new SeekableByteChannelSource(bb, chan);
        return new DataWriter(buf);
    }

    public static DataWriter forOutputStream(OutputStream os) throws IOException {
        return DataWriters.forWritableByteChannel(Channels.newChannel(os));
    }

    public static DataWriter forFile(Path path, OpenOption ... options) throws IOException {
        return DataWriters.forSeekableByteChannel(Files.newByteChannel(path, options));
    }

    private DataWriters() {
    }
}

