/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.nmo;

import info.ata4.bspsrc.lib.nmo.NmoAntiObjective;
import info.ata4.bspsrc.lib.nmo.NmoException;
import info.ata4.bspsrc.lib.nmo.NmoExtraction;
import info.ata4.bspsrc.lib.nmo.NmoObjective;
import info.ata4.io.DataReader;
import info.ata4.io.DataReaders;
import info.ata4.io.DataWriter;
import info.ata4.io.DataWriters;
import info.ata4.io.buffer.ByteBufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NmoFile {
    private static final Logger L = LogManager.getLogger();
    private final byte SIGNATURE = (byte)118;
    private final int VERSION = 1;
    public final List<NmoObjective> nodes = new ArrayList<NmoObjective>();
    public final List<NmoAntiObjective> antiNodes = new ArrayList<NmoAntiObjective>();
    public final List<NmoExtraction> extractions = new ArrayList<NmoExtraction>();

    public void load(Path file, boolean memMapping) throws IOException, NmoException {
        int i;
        L.info("Loading nmo file: " + String.valueOf(file));
        DataReader dataReader = DataReaders.forByteBuffer(NmoFile.createBuffer(file, memMapping).order(ByteOrder.LITTLE_ENDIAN));
        byte signature = dataReader.readByte();
        int version = dataReader.readInt();
        if (signature != 118) {
            throw new NmoException("Invalid nmo file. Expected file signature '118', got '" + signature + "'");
        }
        if (version != 1) {
            throw new NmoException("Unsupported nmo file version '" + version + "'");
        }
        int nodeCount = dataReader.readInt();
        int antiNodeCount = dataReader.readInt();
        int extractionCount = dataReader.readInt();
        for (i = 0; i < nodeCount; ++i) {
            this.nodes.add(new NmoObjective(dataReader));
        }
        for (i = 0; i < antiNodeCount; ++i) {
            this.antiNodes.add(new NmoAntiObjective(dataReader));
        }
        for (i = 0; i < extractionCount; ++i) {
            this.extractions.add(new NmoExtraction(dataReader));
        }
    }

    public void writeAsNmos(Path path) throws IOException {
        L.info("Writing nmos file: " + String.valueOf(path));
        try (DataWriter fileWriter = DataWriters.forFile(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            fileWriter.order(ByteOrder.LITTLE_ENDIAN);
            fileWriter.writeByte((byte)118);
            fileWriter.writeInt(1);
            fileWriter.writeInt(this.nodes.size() + this.extractions.size());
            int xCoordinate = 0;
            int spacing = 75;
            for (NmoObjective nmoObjective : this.nodes) {
                fileWriter.writeByte((byte)1);
                fileWriter.writeInt(nmoObjective.id);
                fileWriter.writeInt(xCoordinate);
                fileWriter.writeInt(0);
                fileWriter.writeStringPrefixed(nmoObjective.comment, Byte.TYPE, StandardCharsets.UTF_8);
                fileWriter.writeInt(nmoObjective.children.size());
                for (Integer child : nmoObjective.children) {
                    fileWriter.writeInt(child);
                }
                xCoordinate += spacing;
            }
            for (NmoExtraction extraction : this.extractions) {
                fileWriter.writeByte((byte)0);
                fileWriter.writeInt(extraction.id);
                fileWriter.writeInt(xCoordinate);
                fileWriter.writeInt(0);
                fileWriter.writeInt(0);
                xCoordinate += spacing;
            }
        }
    }

    private static ByteBuffer createBuffer(Path file, boolean memMapping) throws IOException {
        if (memMapping) {
            return ByteBufferUtils.openReadOnly(file);
        }
        return ByteBufferUtils.load(file);
    }
}

