/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.io.lumpreader;

import info.ata4.bspsrc.lib.io.DataReaderUtil;
import info.ata4.bspsrc.lib.io.lumpreader.LumpReader;
import info.ata4.bspsrc.lib.struct.DStaticProp;
import info.ata4.bspsrc.lib.struct.DStaticPropV10;
import info.ata4.bspsrc.lib.struct.DStaticPropV10CSGO;
import info.ata4.bspsrc.lib.struct.DStaticPropV11;
import info.ata4.bspsrc.lib.struct.DStaticPropV11CSGO;
import info.ata4.bspsrc.lib.struct.DStaticPropV11lite;
import info.ata4.bspsrc.lib.struct.DStaticPropV4;
import info.ata4.bspsrc.lib.struct.DStaticPropV5;
import info.ata4.bspsrc.lib.struct.DStaticPropV5Ship;
import info.ata4.bspsrc.lib.struct.DStaticPropV6;
import info.ata4.bspsrc.lib.struct.DStaticPropV6BGT;
import info.ata4.bspsrc.lib.struct.DStaticPropV6DM;
import info.ata4.bspsrc.lib.struct.DStaticPropV6VIN;
import info.ata4.bspsrc.lib.struct.DStaticPropV7L4D;
import info.ata4.bspsrc.lib.struct.DStaticPropV7VIN;
import info.ata4.bspsrc.lib.struct.DStaticPropV7ZC;
import info.ata4.bspsrc.lib.struct.DStaticPropV8;
import info.ata4.bspsrc.lib.struct.DStaticPropV9;
import info.ata4.bspsrc.lib.struct.DStaticPropV9DE;
import info.ata4.bspsrc.lib.struct.DStaticPropVinScaling;
import info.ata4.bspsrc.lib.vector.Vector3f;
import info.ata4.io.DataReader;
import info.ata4.io.DataReaders;
import info.ata4.io.Seekable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StaticPropLumpReader
implements LumpReader<StaticPropData> {
    private static final Logger L = LogManager.getLogger();
    private static final int PAD_SIZE = 128;
    private final int sprpVersion;
    private final int appId;
    private final List<StaticPropStructDescriptor> staticPropStructDescriptors = Arrays.asList(new StaticPropStructDescriptor(DStaticPropV4::new, 4), new StaticPropStructDescriptor(DStaticPropV5::new, 5), new StaticPropStructDescriptor(DStaticPropV6::new, 6), new StaticPropStructDescriptor(DStaticPropV8::new, 8), new StaticPropStructDescriptor(DStaticPropV9::new, 9), new StaticPropStructDescriptor(DStaticPropV10::new, 10), new StaticPropStructDescriptor(DStaticPropV11lite::new, 11), new StaticPropStructDescriptor(DStaticPropV11::new, 11), new StaticPropStructDescriptor(DStaticPropV5Ship::new, 5, 2400), new StaticPropStructDescriptor(DStaticPropV6BGT::new, 6, 2450), new StaticPropStructDescriptor(DStaticPropV7ZC::new, 7, 22200), new StaticPropStructDescriptor(DStaticPropV6DM::new, 6, 2100), new StaticPropStructDescriptor(DStaticPropV9DE::new, 9, 203810), new StaticPropStructDescriptor(DStaticPropV6VIN::new, 6, 212160), new StaticPropStructDescriptor(DStaticPropV7VIN::new, 7, 212160), new StaticPropStructDescriptor(DStaticPropV7L4D::new, 7, 500), new StaticPropStructDescriptor(DStaticPropV10::new, 7, 440), new StaticPropStructDescriptor(DStaticPropV10CSGO::new, 10, 730), new StaticPropStructDescriptor(DStaticPropV11CSGO::new, 11, 730), new StaticPropStructDescriptor(DStaticPropV10CSGO::new, 10, 222880));

    public StaticPropLumpReader(int sprpVersion, int appId) {
        this.sprpVersion = sprpVersion;
        this.appId = appId;
    }

    @Override
    public StaticPropData read(ByteBuffer buffer) throws IOException {
        DataReader dataReader = DataReaders.forByteBuffer(buffer);
        List<String> staticPropDict = this.readNames(dataReader);
        if (this.appId == 22200) {
            int psextra = dataReader.readInt();
            dataReader.seek((long)psextra * 128L, Seekable.Origin.CURRENT);
        }
        List<Integer> staticPropLeafs = this.readLeafs(dataReader);
        Map<Object, Object> scaling = this.appId == 212160 && this.sprpVersion > 5 ? this.readVindictusScaling(dataReader) : Collections.emptyMap();
        List<? extends DStaticProp> staticProps = this.readStaticProps(dataReader);
        for (int i = 0; i < staticProps.size(); ++i) {
            DStaticProp sp = staticProps.get(i);
            if (!scaling.containsKey(i) || !(sp instanceof DStaticPropVinScaling)) continue;
            ((DStaticPropVinScaling)((Object)sp)).setScaling((Vector3f)scaling.get(i));
        }
        if (dataReader.hasRemaining()) {
            L.warn(String.format("%d bytes remaining after reading", dataReader.remaining()));
        }
        return new StaticPropData(staticPropDict, staticPropLeafs, staticProps);
    }

    private List<String> readNames(DataReader reader) throws IOException {
        int nameCount = reader.readInt();
        return DataReaderUtil.readChunks(reader, r -> r.readStringFixed(128), nameCount);
    }

    private List<Integer> readLeafs(DataReader reader) throws IOException {
        int leaveCount = reader.readInt();
        return DataReaderUtil.readChunks(reader, DataReader::readUnsignedShort, leaveCount);
    }

    private Map<Integer, Vector3f> readVindictusScaling(DataReader reader) throws IOException {
        int scalingCount = reader.readInt();
        HashMap<Integer, Vector3f> scaling = new HashMap<Integer, Vector3f>();
        for (int i = 0; i < scalingCount; ++i) {
            scaling.put(reader.readInt(), Vector3f.read(reader));
        }
        return scaling;
    }

    private List<? extends DStaticProp> readStaticProps(DataReader reader) throws IOException {
        int propStaticCount = reader.readInt();
        if (propStaticCount == 0) {
            return Collections.emptyList();
        }
        int propStaticSize = (int)(reader.remaining() / (long)propStaticCount);
        Supplier dStaticPropSupplier = this.staticPropStructDescriptors.stream().filter(descriptor -> descriptor.version == this.sprpVersion).filter(descriptor -> descriptor.appId == -1 || descriptor.appId == this.appId).filter(descriptor -> descriptor.size == propStaticSize).max(Comparator.comparing(descriptor -> descriptor.appId != -1)).map(descriptor -> {
            L.info(String.format("Using '%s' for sprp version %d", descriptor.structSupplier.get().getClass().getSimpleName(), this.sprpVersion));
            return descriptor.structSupplier;
        }).orElseGet(() -> {
            L.warn(String.format("Couldn't find static prop struct for appId %d, version %d, size %d", this.appId, this.sprpVersion, propStaticSize));
            L.warn("Falling back to static prop v4");
            return () -> new DStaticPropV4Padded(propStaticSize);
        });
        return DataReaderUtil.readChunks(reader, arg_0 -> StaticPropLumpReader.lambda$readStaticProps$8((Supplier)dStaticPropSupplier, arg_0), propStaticCount);
    }

    @Override
    public StaticPropData defaultData() {
        return new StaticPropData();
    }

    private static /* synthetic */ DStaticProp lambda$readStaticProps$8(Supplier dStaticPropSupplier, DataReader r) throws IOException {
        return DataReaderUtil.readDStruct(r, (DStaticProp)dStaticPropSupplier.get());
    }

    private static class StaticPropStructDescriptor {
        public final Supplier<? extends DStaticProp> structSupplier;
        public final int version;
        public final int appId;
        public final int size;

        private StaticPropStructDescriptor(Supplier<? extends DStaticProp> structSupplier, int version) {
            this(structSupplier, version, -1);
        }

        private StaticPropStructDescriptor(Supplier<? extends DStaticProp> structSupplier, int version, int appId) {
            this.structSupplier = Objects.requireNonNull(structSupplier);
            this.version = version;
            this.appId = appId;
            this.size = structSupplier.get().getSize();
        }
    }

    public static class StaticPropData {
        public final List<String> names;
        public final List<Integer> leafs;
        public final List<? extends DStaticProp> props;

        public StaticPropData() {
            this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public StaticPropData(List<String> names, List<Integer> leafs, List<? extends DStaticProp> props) {
            this.names = List.copyOf(names);
            this.leafs = List.copyOf(leafs);
            this.props = List.copyOf(props);
        }
    }

    private static class DStaticPropV4Padded
    extends DStaticPropV4 {
        private final int propStaticSize;

        public DStaticPropV4Padded(int propStaticSize) {
            this.propStaticSize = propStaticSize;
        }

        @Override
        public int getSize() {
            return this.propStaticSize;
        }

        @Override
        public void read(DataReader in) throws IOException {
            super.read(in);
            in.seek(this.propStaticSize - super.getSize(), Seekable.Origin.CURRENT);
        }
    }
}

