/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.io.lumpreader;

import info.ata4.bspsrc.lib.io.DataReaderUtil;
import info.ata4.bspsrc.lib.io.lumpreader.LumpReader;
import info.ata4.bspsrc.lib.struct.DOccluderData;
import info.ata4.bspsrc.lib.struct.DOccluderPolyData;
import info.ata4.io.DataReader;
import info.ata4.io.DataReaders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OcclusionLumpReader<T extends DOccluderData>
implements LumpReader<OcclusionData<T>> {
    private static final Logger L = LogManager.getLogger();
    private final Supplier<? extends T> dOccluderDataSupplier;

    public OcclusionLumpReader(Supplier<? extends T> dOccluderDataSupplier) {
        this.dOccluderDataSupplier = Objects.requireNonNull(dOccluderDataSupplier);
    }

    @Override
    public OcclusionData<T> read(ByteBuffer buffer) throws IOException {
        DataReader dataReader = DataReaders.forByteBuffer(buffer);
        int dOcculderDataCount = dataReader.readInt();
        List<DOccluderData> dOccluderData = DataReaderUtil.readChunks(dataReader, r -> DataReaderUtil.readDStruct(r, (DOccluderData)this.dOccluderDataSupplier.get()), dOcculderDataCount);
        int dOccluderPolyCount = dataReader.readInt();
        List<DOccluderPolyData> dOccluderPolyData = DataReaderUtil.readChunks(dataReader, r -> DataReaderUtil.readDStruct(r, new DOccluderPolyData()), dOccluderPolyCount);
        int vertexCount = dataReader.readInt();
        List<Integer> vertexIndices = DataReaderUtil.readChunks(dataReader, DataReader::readInt, vertexCount);
        if (dataReader.hasRemaining()) {
            L.warn(String.format("%d bytes remaining after reading", dataReader.remaining()));
        }
        return new OcclusionData<DOccluderData>(dOccluderData, dOccluderPolyData, vertexIndices);
    }

    @Override
    public OcclusionData<T> defaultData() {
        return new OcclusionData();
    }

    public static class OcclusionData<T extends DOccluderData> {
        public final List<T> dOccluderData;
        public final List<DOccluderPolyData> dOccluderPolyData;
        public final List<Integer> vertexIndices;

        public OcclusionData() {
            this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public OcclusionData(List<T> dOccluderData, List<DOccluderPolyData> dOccluderPolyData, List<Integer> vertexIndices) {
            this.dOccluderData = List.copyOf(dOccluderData);
            this.dOccluderPolyData = List.copyOf(dOccluderPolyData);
            this.vertexIndices = List.copyOf(vertexIndices);
        }
    }
}

