/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.app;

import info.ata4.bspsrc.lib.app.SourceApp;
import info.ata4.bspsrc.lib.app.definitions.AlienSwarmDef;
import info.ata4.bspsrc.lib.app.definitions.BlackMesaDef;
import info.ata4.bspsrc.lib.app.definitions.BladeSymphonyDef;
import info.ata4.bspsrc.lib.app.definitions.BloodyGoodTimeDef;
import info.ata4.bspsrc.lib.app.definitions.ContagionDef;
import info.ata4.bspsrc.lib.app.definitions.CounterStrikeGlobalOffensiveDef;
import info.ata4.bspsrc.lib.app.definitions.CounterStrikeSourceDef;
import info.ata4.bspsrc.lib.app.definitions.CyberDiverDef;
import info.ata4.bspsrc.lib.app.definitions.DarkMessiahOfMightMagicDef;
import info.ata4.bspsrc.lib.app.definitions.DayOfDefeatSourceDef;
import info.ata4.bspsrc.lib.app.definitions.DearEstherDef;
import info.ata4.bspsrc.lib.app.definitions.Dota2Def;
import info.ata4.bspsrc.lib.app.definitions.GarrysModDef;
import info.ata4.bspsrc.lib.app.definitions.HalfLife2DeathmatchDef;
import info.ata4.bspsrc.lib.app.definitions.HalfLife2Def;
import info.ata4.bspsrc.lib.app.definitions.HalfLife2EpisodeOneDef;
import info.ata4.bspsrc.lib.app.definitions.HalfLife2EpisodeTwoDef;
import info.ata4.bspsrc.lib.app.definitions.HalfLifeSourceDef;
import info.ata4.bspsrc.lib.app.definitions.InsurgencyDef;
import info.ata4.bspsrc.lib.app.definitions.Left4Dead2Def;
import info.ata4.bspsrc.lib.app.definitions.Left4DeadDef;
import info.ata4.bspsrc.lib.app.definitions.NoMoreRoomInHellDef;
import info.ata4.bspsrc.lib.app.definitions.Portal2Def;
import info.ata4.bspsrc.lib.app.definitions.PortalDef;
import info.ata4.bspsrc.lib.app.definitions.Postal3Def;
import info.ata4.bspsrc.lib.app.definitions.SiNEpisodesEmergenceDef;
import info.ata4.bspsrc.lib.app.definitions.SynergyDef;
import info.ata4.bspsrc.lib.app.definitions.TacticalInterventionDef;
import info.ata4.bspsrc.lib.app.definitions.TeamFortress2Def;
import info.ata4.bspsrc.lib.app.definitions.TheShipDef;
import info.ata4.bspsrc.lib.app.definitions.TitanfallDef;
import info.ata4.bspsrc.lib.app.definitions.VampireTheMasqueradeBloodlinesDef;
import info.ata4.bspsrc.lib.app.definitions.VindictusMabinogiHeroesDef;
import info.ata4.bspsrc.lib.app.definitions.ZenoClashDef;
import info.ata4.bspsrc.lib.app.definitions.ZombiePanicSourceDef;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SourceAppDB {
    private static final Logger L = LogManager.getLogger();
    private static SourceAppDB instance;
    private final List<SourceApp> appList = Arrays.asList(AlienSwarmDef.APP, BlackMesaDef.APP, BladeSymphonyDef.APP, BloodyGoodTimeDef.APP, ContagionDef.APP, CounterStrikeGlobalOffensiveDef.APP, CounterStrikeSourceDef.APP, CyberDiverDef.APP, DarkMessiahOfMightMagicDef.APP, DayOfDefeatSourceDef.APP, DearEstherDef.APP, Dota2Def.APP, GarrysModDef.APP, HalfLife2DeathmatchDef.APP, HalfLife2Def.APP, HalfLife2EpisodeOneDef.APP, HalfLife2EpisodeTwoDef.APP, HalfLifeSourceDef.APP, InsurgencyDef.APP, Left4Dead2Def.APP, Left4DeadDef.APP, NoMoreRoomInHellDef.APP, Portal2Def.APP, PortalDef.APP, Postal3Def.APP, SiNEpisodesEmergenceDef.APP, SynergyDef.APP, TacticalInterventionDef.APP, TeamFortress2Def.APP, TheShipDef.APP, TitanfallDef.APP, VampireTheMasqueradeBloodlinesDef.APP, VindictusMabinogiHeroesDef.APP, ZenoClashDef.APP, ZombiePanicSourceDef.APP);

    public static SourceAppDB getInstance() {
        if (instance == null) {
            instance = new SourceAppDB();
        }
        return instance;
    }

    public int find(String bspName, int bspVersion, Set<String> classNames) {
        class SourceAppScore {
            public final SourceApp app;
            public final float score;

            SourceAppScore(SourceAppDB this$0, SourceApp app, float score) {
                this.app = Objects.requireNonNull(app);
                this.score = score;
            }
        }
        return this.appList.stream().map(app -> new SourceAppScore(this, (SourceApp)app, this.calculateAppScore((SourceApp)app, bspName, bspVersion, classNames))).peek(appScore -> L.debug(String.format("App %s has score %f", appScore.app.getName(), Float.valueOf(appScore.score)))).max(Comparator.comparing(appScore -> Float.valueOf(appScore.score))).filter(appScore -> appScore.score > 0.0f).map(appScore -> appScore.app).map(SourceApp::getAppId).orElse(0);
    }

    private float calculateAppScore(SourceApp app, String bspName, int bspVersion, Set<String> classNames) {
        return (app.checkVersion(bspVersion).orElse(true) != false ? 0.0f : Float.NEGATIVE_INFINITY) + app.checkEntities(classNames).orElse(Float.valueOf(0.0f)).floatValue() * app.getPointsEntities() + (app.checkName(bspName).orElse(false) != false ? app.getPointsFilePattern() : 0.0f);
    }

    public Optional<String> getName(int appId) {
        return this.appList.stream().filter(app -> app.getAppId() == appId).findAny().map(SourceApp::getName);
    }

    public Map<Integer, String> getAppList() {
        return this.appList.stream().collect(Collectors.toMap(SourceApp::getAppId, SourceApp::getName));
    }

    public static URI getSteamStoreURI(int appId) {
        if (appId <= 0) {
            return null;
        }
        try {
            return new URI(String.format("http://store.steampowered.com/app/%d/", appId));
        }
        catch (URISyntaxException ex) {
            L.warn("", (Throwable)ex);
            return null;
        }
    }
}

