/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.app;

import info.ata4.bspsrc.lib.app.SourceApp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class SourceAppBuilder {
    private String name;
    private int appId;
    private int versionMin = -1;
    private int versionMax = -1;
    private Pattern filePattern = null;
    private Set<String> entities = Collections.emptySet();
    private float pointsEntities = 20.0f;
    private float pointsFilePattern = 3.0f;

    public SourceAppBuilder setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public SourceAppBuilder setAppId(int appId) {
        this.appId = appId;
        return this;
    }

    public SourceAppBuilder setVersionMin(int versionMin) {
        this.versionMin = versionMin;
        return this;
    }

    public SourceAppBuilder setVersionMax(int versionMax) {
        this.versionMax = versionMax;
        return this;
    }

    public SourceAppBuilder setFilePattern(Pattern filePattern) {
        this.filePattern = filePattern;
        return this;
    }

    public SourceAppBuilder setEntities(String ... entities) {
        this.entities = new HashSet<String>(Arrays.asList(entities));
        return this;
    }

    public SourceAppBuilder setPointsEntities(float pointsEntities) {
        this.pointsEntities = pointsEntities;
        return this;
    }

    public SourceAppBuilder setPointsFilePattern(float pointsFilePattern) {
        this.pointsFilePattern = pointsFilePattern;
        return this;
    }

    public SourceApp build() {
        return new SourceApp(this.name, this.appId, this.versionMin, this.versionMax, this.filePattern, this.entities, this.pointsEntities, this.pointsFilePattern);
    }
}

