/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib;

import info.ata4.bspsrc.lib.BspFile;
import info.ata4.bspsrc.lib.app.SourceAppDB;
import info.ata4.bspsrc.lib.entity.Entity;
import info.ata4.bspsrc.lib.io.lumpreader.ChunksLumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.DStructChunksLumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.EntityLumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.IntegerChunksLumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.LumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.MapFlagsLumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.OcclusionLumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.StaticPropLumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.TexdataStringLumpReader;
import info.ata4.bspsrc.lib.io.lumpreader.UShortChunksLumpReader;
import info.ata4.bspsrc.lib.lump.AbstractLump;
import info.ata4.bspsrc.lib.lump.GameLump;
import info.ata4.bspsrc.lib.lump.Lump;
import info.ata4.bspsrc.lib.lump.LumpType;
import info.ata4.bspsrc.lib.struct.BspData;
import info.ata4.bspsrc.lib.struct.DAreaportal;
import info.ata4.bspsrc.lib.struct.DAreaportalVin;
import info.ata4.bspsrc.lib.struct.DBrush;
import info.ata4.bspsrc.lib.struct.DBrushSide;
import info.ata4.bspsrc.lib.struct.DBrushSideV2;
import info.ata4.bspsrc.lib.struct.DBrushSideVin;
import info.ata4.bspsrc.lib.struct.DCubemapSample;
import info.ata4.bspsrc.lib.struct.DDispInfo;
import info.ata4.bspsrc.lib.struct.DDispInfoBSP17;
import info.ata4.bspsrc.lib.struct.DDispInfoBSP22;
import info.ata4.bspsrc.lib.struct.DDispInfoBSP23;
import info.ata4.bspsrc.lib.struct.DDispInfoVin;
import info.ata4.bspsrc.lib.struct.DDispMultiBlend;
import info.ata4.bspsrc.lib.struct.DDispTri;
import info.ata4.bspsrc.lib.struct.DDispVert;
import info.ata4.bspsrc.lib.struct.DEdge;
import info.ata4.bspsrc.lib.struct.DEdgeVin;
import info.ata4.bspsrc.lib.struct.DFace;
import info.ata4.bspsrc.lib.struct.DFaceBSP17;
import info.ata4.bspsrc.lib.struct.DFaceBSP18;
import info.ata4.bspsrc.lib.struct.DFaceVTMB;
import info.ata4.bspsrc.lib.struct.DFaceVinV1;
import info.ata4.bspsrc.lib.struct.DFaceVinV2;
import info.ata4.bspsrc.lib.struct.DLeafV0;
import info.ata4.bspsrc.lib.struct.DLeafV1;
import info.ata4.bspsrc.lib.struct.DLeafVin;
import info.ata4.bspsrc.lib.struct.DModel;
import info.ata4.bspsrc.lib.struct.DModelDM;
import info.ata4.bspsrc.lib.struct.DNode;
import info.ata4.bspsrc.lib.struct.DNodeVin;
import info.ata4.bspsrc.lib.struct.DOccluderData;
import info.ata4.bspsrc.lib.struct.DOccluderDataV1;
import info.ata4.bspsrc.lib.struct.DOverlay;
import info.ata4.bspsrc.lib.struct.DOverlayDota2;
import info.ata4.bspsrc.lib.struct.DOverlayFade;
import info.ata4.bspsrc.lib.struct.DOverlaySystemLevel;
import info.ata4.bspsrc.lib.struct.DOverlayVin;
import info.ata4.bspsrc.lib.struct.DPlane;
import info.ata4.bspsrc.lib.struct.DPrimitive;
import info.ata4.bspsrc.lib.struct.DStruct;
import info.ata4.bspsrc.lib.struct.DTexData;
import info.ata4.bspsrc.lib.struct.DTexInfo;
import info.ata4.bspsrc.lib.struct.DTexInfoDM;
import info.ata4.bspsrc.lib.struct.DVertex;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BspFileReader {
    private static final Logger L = LogManager.getLogger();
    private final BspFile bspFile;
    private final BspData bspData;

    public BspFileReader(BspFile bspFile, BspData bspData) {
        this.bspFile = bspFile;
        this.bspData = bspData;
        if (bspFile.getFile() == null) {
            throw new IllegalArgumentException("BSP file is unloaded");
        }
        if (bspFile.isCompressed()) {
            bspFile.uncompress();
        }
    }

    public BspFileReader(BspFile bspFile) {
        this(bspFile, new BspData());
    }

    private int appId() {
        return this.bspFile.getAppId();
    }

    public void loadAll() {
        this.loadEntities();
        this.loadVertices();
        this.loadEdges();
        this.loadFaces();
        this.loadOriginalFaces();
        this.loadModels();
        this.loadSurfaceEdges();
        this.loadOccluders();
        this.loadTexInfo();
        this.loadTexData();
        this.loadStaticProps();
        this.loadCubemaps();
        this.loadPlanes();
        this.loadBrushes();
        this.loadBrushSides();
        this.loadAreaportals();
        this.loadClipPortalVertices();
        this.loadDispInfos();
        this.loadDispVertices();
        this.loadDispTriangleTags();
        this.loadDispMultiBlend();
        this.loadNodes();
        this.loadLeaves();
        this.loadLeafFaces();
        this.loadLeafBrushes();
        this.loadOverlays();
        this.loadFlags();
    }

    public void loadPlanes() {
        if (this.bspData.planes != null) {
            return;
        }
        this.bspData.planes = this.readDStructChunksLump(LumpType.LUMP_PLANES, DPlane::new);
        L.debug(String.format("%d planes", this.bspData.planes.size()));
    }

    public void loadBrushes() {
        if (this.bspData.brushes != null) {
            return;
        }
        this.bspData.brushes = this.readDStructChunksLump(LumpType.LUMP_BRUSHES, DBrush::new);
        L.debug(String.format("%d brushes", this.bspData.brushes.size()));
    }

    public void loadBrushSides() {
        if (this.bspData.brushSides != null) {
            return;
        }
        Supplier<DBrushSide> dStructSupplier = this.appId() == 212160 ? DBrushSideVin::new : (this.bspFile.getVersion() >= 21 && this.appId() != 550 ? DBrushSideV2::new : DBrushSide::new);
        this.bspData.brushSides = this.readDStructChunksLump(LumpType.LUMP_BRUSHSIDES, dStructSupplier);
        L.debug(String.format("%d brush sides", this.bspData.brushSides.size()));
    }

    public void loadVertices() {
        if (this.bspData.verts != null) {
            return;
        }
        this.bspData.verts = this.readDStructChunksLump(LumpType.LUMP_VERTEXES, DVertex::new);
        L.debug(String.format("%d vertices", this.bspData.verts.size()));
    }

    public void loadClipPortalVertices() {
        if (this.bspData.clipPortalVerts != null) {
            return;
        }
        this.bspData.clipPortalVerts = this.readDStructChunksLump(LumpType.LUMP_CLIPPORTALVERTS, DVertex::new);
        L.debug(String.format("%d areaportal vertices", this.bspData.clipPortalVerts.size()));
    }

    public void loadEdges() {
        if (this.bspData.edges != null) {
            return;
        }
        Supplier<DEdge> struct = this.appId() == 212160 ? DEdgeVin::new : DEdge::new;
        this.bspData.edges = this.readDStructChunksLump(LumpType.LUMP_EDGES, struct);
        L.debug(String.format("%d edges", this.bspData.edges.size()));
    }

    private Supplier<? extends DFace> faceDStructSupplier(int lumpVersion) {
        switch (this.appId()) {
            case 2600: {
                return DFaceVTMB::new;
            }
            case 212160: {
                if (lumpVersion == 2) {
                    return DFaceVinV2::new;
                }
                return DFaceVinV1::new;
            }
        }
        switch (this.bspFile.getVersion()) {
            case 17: {
                return DFaceBSP17::new;
            }
            case 18: {
                return DFaceBSP18::new;
            }
        }
        return DFace::new;
    }

    public void loadFaces() {
        if (this.bspData.faces != null) {
            return;
        }
        boolean useHdrLump = this.bspFile.canReadLump(LumpType.LUMP_FACES_HDR) && this.bspFile.getLump(LumpType.LUMP_FACES_HDR).getLength() != 0;
        LumpType faceLumpType = useHdrLump ? LumpType.LUMP_FACES_HDR : LumpType.LUMP_FACES;
        this.bspData.faces = this.readDStructChunksLump(faceLumpType, this::faceDStructSupplier);
        L.debug(String.format("%d faces", this.bspData.faces.size()));
    }

    public void loadOriginalFaces() {
        if (this.bspData.origFaces != null) {
            return;
        }
        this.bspData.origFaces = this.readDStructChunksLump(LumpType.LUMP_ORIGINALFACES, this::faceDStructSupplier);
        L.debug(String.format("%d original faces", this.bspData.origFaces.size()));
    }

    public void loadModels() {
        if (this.bspData.models != null) {
            return;
        }
        Supplier<DModel> dStructSupplier = this.appId() == 2100 ? DModelDM::new : DModel::new;
        this.bspData.models = this.readDStructChunksLump(LumpType.LUMP_MODELS, dStructSupplier);
        L.debug(String.format("%d models", this.bspData.models.size()));
    }

    public void loadSurfaceEdges() {
        if (this.bspData.surfEdges != null) {
            return;
        }
        this.bspData.surfEdges = this.readLump(LumpType.LUMP_SURFEDGES, new IntegerChunksLumpReader());
        L.debug(String.format("%d surface edges", this.bspData.surfEdges.size()));
    }

    public void loadStaticProps() {
        if (this.bspData.staticProps != null && this.bspData.staticPropName != null && this.bspData.staticPropLeaf != null) {
            return;
        }
        StaticPropLumpReader.StaticPropData staticPropData = this.readGameLump("sprp", lumpVersion -> new StaticPropLumpReader((int)lumpVersion, this.appId()), StaticPropLumpReader.StaticPropData::new);
        this.bspData.staticPropName = staticPropData.names;
        this.bspData.staticProps = staticPropData.props;
        this.bspData.staticPropLeaf = staticPropData.leafs;
        L.debug(String.format("%d static prop names", staticPropData.names.size()));
        L.debug(String.format("%d static props", staticPropData.props.size()));
        L.debug(String.format("%d static prop leafs", staticPropData.leafs.size()));
    }

    public void loadCubemaps() {
        if (this.bspData.cubemaps != null) {
            return;
        }
        this.bspData.cubemaps = this.readDStructChunksLump(LumpType.LUMP_CUBEMAPS, DCubemapSample::new);
        L.debug(String.format("%d cubemaps", this.bspData.cubemaps.size()));
    }

    public void loadDispInfos() {
        if (this.bspData.dispinfos != null) {
            return;
        }
        Supplier<DDispInfo> dStructSupplier = DDispInfo::new;
        int bspv = this.bspFile.getVersion();
        switch (this.appId()) {
            case 212160: {
                dStructSupplier = DDispInfoVin::new;
                break;
            }
            case 220: {
                if (bspv != 17) break;
                dStructSupplier = DDispInfoBSP17::new;
                break;
            }
            case 570: {
                if (bspv == 22) {
                    dStructSupplier = DDispInfoBSP22::new;
                    break;
                }
                if (bspv < 23) break;
                dStructSupplier = DDispInfoBSP23::new;
            }
        }
        this.bspData.dispinfos = this.readDStructChunksLump(LumpType.LUMP_DISPINFO, dStructSupplier);
        L.debug(String.format("%d displacement infos", this.bspData.dispinfos.size()));
    }

    public void loadDispVertices() {
        if (this.bspData.dispverts != null) {
            return;
        }
        this.bspData.dispverts = this.readDStructChunksLump(LumpType.LUMP_DISP_VERTS, DDispVert::new);
        L.debug(String.format("%d displacement vertices", this.bspData.dispverts.size()));
    }

    public void loadDispTriangleTags() {
        if (this.bspData.disptris != null) {
            return;
        }
        this.bspData.disptris = this.readDStructChunksLump(LumpType.LUMP_DISP_TRIS, DDispTri::new);
        L.debug(String.format("%d displacement triangles", this.bspData.disptris.size()));
    }

    public void loadDispMultiBlend() {
        if (this.bspData.dispmultiblend != null) {
            return;
        }
        LumpType lumpType = this.appId() == 362890 ? LumpType.LUMP_OVERLAY_SYSTEM_LEVELS : LumpType.LUMP_DISP_MULTIBLEND;
        this.bspData.dispmultiblend = this.readDStructChunksLump(lumpType, DDispMultiBlend::new);
        L.debug(String.format("%d displacement multiblend", this.bspData.dispmultiblend.size()));
    }

    public void loadTexInfo() {
        if (this.bspData.texinfos != null) {
            return;
        }
        Supplier<DTexInfo> dStructSupplier = this.appId() == 2100 ? DTexInfoDM::new : DTexInfo::new;
        this.bspData.texinfos = this.readDStructChunksLump(LumpType.LUMP_TEXINFO, dStructSupplier);
        L.debug(String.format("%d texture infos", this.bspData.texinfos.size()));
    }

    public void loadTexData() {
        if (this.bspData.texdatas != null) {
            return;
        }
        this.bspData.texdatas = this.readDStructChunksLump(LumpType.LUMP_TEXDATA, DTexData::new);
        L.debug(String.format("%d texture data", this.bspData.texdatas.size()));
        this.loadTexDataStrings();
    }

    private void loadTexDataStrings() {
        if (this.bspData.texnames != null) {
            return;
        }
        List<Integer> stringTableData = this.readLump(LumpType.LUMP_TEXDATA_STRING_TABLE, new IntegerChunksLumpReader());
        this.bspData.texnames = this.readLump(LumpType.LUMP_TEXDATA_STRING_DATA, new TexdataStringLumpReader(stringTableData));
        L.debug(String.format("%d texture names", this.bspData.texnames.size()));
    }

    public void loadEntities() {
        if (this.bspData.entities != null) {
            return;
        }
        boolean allowEscSeq = this.bspFile.getVersion() == 17;
        this.bspData.entities = this.readLump(LumpType.LUMP_ENTITIES, new EntityLumpReader(allowEscSeq));
        L.debug(String.format("%d entities", this.bspData.entities.size()));
        Set<String> entityClasses = this.bspData.entities.stream().map(Entity::getClassName).collect(Collectors.toSet());
        if (this.appId() == 0) {
            int appId = SourceAppDB.getInstance().find(this.bspFile.getName(), this.bspFile.getVersion(), entityClasses);
            this.bspFile.setAppId(appId);
        }
    }

    public void loadNodes() {
        if (this.bspData.nodes != null) {
            return;
        }
        Supplier<DNode> dStructSupplier = this.appId() == 212160 ? DNodeVin::new : DNode::new;
        this.bspData.nodes = this.readDStructChunksLump(LumpType.LUMP_NODES, dStructSupplier);
        L.debug(String.format("%d nodes", this.bspData.nodes.size()));
    }

    public void loadLeaves() {
        if (this.bspData.leaves != null) {
            return;
        }
        Function dStructSupplierCreator = lumpVersion -> {
            if (this.appId() == 212160) {
                return DLeafVin::new;
            }
            if (lumpVersion == 0 && this.bspFile.getVersion() == 19) {
                return DLeafV0::new;
            }
            return DLeafV1::new;
        };
        this.bspData.leaves = this.readDStructChunksLump(LumpType.LUMP_LEAFS, dStructSupplierCreator);
        L.debug(String.format("%d leaves", this.bspData.leaves.size()));
    }

    public void loadLeafFaces() {
        if (this.bspData.leafFaces != null) {
            return;
        }
        ChunksLumpReader lumpReader = this.appId() != 212160 ? new UShortChunksLumpReader() : new IntegerChunksLumpReader();
        this.bspData.leafFaces = this.readLump(LumpType.LUMP_LEAFFACES, lumpReader);
        L.debug(String.format("%d leaf faces", this.bspData.leafFaces.size()));
    }

    public void loadLeafBrushes() {
        if (this.bspData.leafBrushes != null) {
            return;
        }
        ChunksLumpReader lumpReader = this.appId() != 212160 ? new UShortChunksLumpReader() : new IntegerChunksLumpReader();
        this.bspData.leafBrushes = this.readLump(LumpType.LUMP_LEAFBRUSHES, lumpReader);
        L.debug(String.format("%d leaf brushes", this.bspData.leafBrushes.size()));
    }

    public void loadOverlays() {
        if (this.bspData.overlays != null) {
            return;
        }
        Supplier<DOverlay> dStructSupplier = this.appId() == 212160 ? DOverlayVin::new : (this.appId() == 570 ? DOverlayDota2::new : DOverlay::new);
        this.bspData.overlays = this.readDStructChunksLump(LumpType.LUMP_OVERLAYS, dStructSupplier);
        L.debug(String.format("%d overlays", this.bspData.overlays.size()));
        if (this.bspData.overlayFades == null) {
            this.bspData.overlayFades = this.readDStructChunksLump(LumpType.LUMP_OVERLAY_FADES, DOverlayFade::new);
            L.debug(String.format("%d overlay fades", this.bspData.overlayFades.size()));
        }
        if (this.bspData.overlaySysLevels == null) {
            this.bspData.overlaySysLevels = this.appId() == 362890 ? Collections.emptyList() : this.readDStructChunksLump(LumpType.LUMP_OVERLAY_SYSTEM_LEVELS, DOverlaySystemLevel::new);
            L.debug(String.format("%d overlay sys levels", this.bspData.overlaySysLevels.size()));
        }
    }

    public void loadAreaportals() {
        if (this.bspData.areaportals != null) {
            return;
        }
        Supplier<DAreaportal> dStructSupplier = this.appId() == 212160 ? DAreaportalVin::new : DAreaportal::new;
        this.bspData.areaportals = this.readDStructChunksLump(LumpType.LUMP_AREAPORTALS, dStructSupplier);
        L.debug(String.format("%d areaportals", this.bspData.areaportals.size()));
    }

    public void loadOccluders() {
        if (this.bspData.occluderDatas != null) {
            return;
        }
        Function<Integer, LumpReader> lumpReaderCreator = lumpVersion -> {
            int alteredLumpVersion = lumpVersion;
            if (this.bspFile.getAppId() == 238430) {
                alteredLumpVersion = 1;
            }
            Supplier<DOccluderData> dStructSupplier = alteredLumpVersion == 0 ? DOccluderData::new : DOccluderDataV1::new;
            return new OcclusionLumpReader<DOccluderData>(dStructSupplier);
        };
        OcclusionLumpReader.OcclusionData occlusionData = this.readLump(LumpType.LUMP_OCCLUSION, lumpReaderCreator, OcclusionLumpReader.OcclusionData::new);
        this.bspData.occluderDatas = occlusionData.dOccluderData;
        this.bspData.occluderPolyDatas = occlusionData.dOccluderPolyData;
        this.bspData.occluderVerts = occlusionData.vertexIndices;
        L.debug(String.format("%d occluders", this.bspData.occluderDatas.size()));
        L.debug(String.format("%d occluder poly data", this.bspData.occluderPolyDatas.size()));
        L.debug(String.format("%d occluder vertices", this.bspData.occluderVerts.size()));
    }

    public void loadFlags() {
        if (this.bspData.mapFlags != null) {
            return;
        }
        this.bspData.mapFlags = this.readLump(LumpType.LUMP_MAP_FLAGS, new MapFlagsLumpReader());
        L.debug(String.format("map flags: %s", this.bspData.mapFlags));
    }

    public void loadPrimitives() {
        if (this.bspData.prims != null) {
            return;
        }
        this.bspData.prims = this.readDStructChunksLump(LumpType.LUMP_PRIMITIVES, DPrimitive::new);
        L.debug(String.format("%d primitives", this.bspData.prims.size()));
    }

    public void loadPrimIndices() {
        if (this.bspData.primIndices != null) {
            return;
        }
        this.bspData.primIndices = this.readLump(LumpType.LUMP_PRIMINDICES, new UShortChunksLumpReader());
        L.debug(String.format("%d primitives indices", this.bspData.primIndices.size()));
    }

    public void loadPrimVerts() {
        if (this.bspData.primVerts != null) {
            return;
        }
        this.bspData.primVerts = this.readDStructChunksLump(LumpType.LUMP_PRIMVERTS, DVertex::new);
        L.debug(String.format("%d primitives vertices", this.bspData.primVerts.size()));
    }

    private <T extends DStruct> List<T> readDStructChunksLump(LumpType lumpType, Supplier<? extends T> dStructSupplier) {
        return this.readDStructChunksLump(lumpType, (? super Integer integer) -> dStructSupplier);
    }

    private <T extends DStruct> List<T> readDStructChunksLump(LumpType lumpType, Function<? super Integer, Supplier<? extends T>> dStructSupplierCreator) {
        return this.readLump(lumpType, lumpVersion -> new DStructChunksLumpReader((Supplier)dStructSupplierCreator.apply((Integer)lumpVersion)), Collections::emptyList);
    }

    private <T> T readLump(LumpType lumpType, LumpReader<? extends T> lumpReader) {
        return (T)this.readLump(lumpType, lumpVersion -> lumpReader, lumpReader::defaultData);
    }

    private <T> T readLump(LumpType lumpType, Function<? super Integer, ? extends LumpReader<? extends T>> lumpReaderCreator, Supplier<? extends T> defaultDataSupplier) {
        if (!this.bspFile.canReadLump(lumpType)) {
            L.warn(String.format("Tried reading lump '%s', but it is not supported by the bsp's version", new Object[]{lumpType}));
            return defaultDataSupplier.get();
        }
        Lump lump = this.bspFile.getLump(lumpType);
        LumpReader<? extends T> lumpReader = lumpReaderCreator.apply(lump.getVersion());
        return this.readAbstractLump(lump, lumpReader);
    }

    private <T> T readGameLump(String sid, Function<Integer, ? extends LumpReader<? extends T>> lumpReaderCreator, Supplier<? extends T> defaultDataSupplier) {
        GameLump gameLump = this.bspFile.getGameLump(sid);
        if (gameLump == null) {
            L.warn(String.format("Tried reading game lump '%s', but it was not present in the bsp", sid));
            return defaultDataSupplier.get();
        }
        LumpReader<? extends T> lumpReader = lumpReaderCreator.apply(gameLump.getVersion());
        return this.readAbstractLump(gameLump, lumpReader);
    }

    private <T> T readAbstractLump(AbstractLump lump, LumpReader<? extends T> lumpReader) {
        T returnData;
        if (lump.getLength() == 0) {
            L.warn(String.format("Lump %s is empty", lump));
            return lumpReader.defaultData();
        }
        L.debug(String.format("Reading %s", lump));
        try {
            returnData = lumpReader.read(lump.getBuffer());
        }
        catch (Exception e) {
            L.warn(String.format("An error occurred while trying to read lump %s", lump), (Throwable)e);
            returnData = lumpReader.defaultData();
        }
        L.debug(String.format("Finished reading %s", lump));
        return returnData;
    }

    public BspFile getBspFile() {
        return this.bspFile;
    }

    public BspData getData() {
        return this.bspData;
    }
}

