/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.util;

import info.ata4.bspsrc.decompiler.util.Winding;
import info.ata4.bspsrc.lib.struct.BspData;
import info.ata4.bspsrc.lib.struct.DAreaportal;
import info.ata4.bspsrc.lib.struct.DBrush;
import info.ata4.bspsrc.lib.struct.DBrushSide;
import info.ata4.bspsrc.lib.struct.DFace;
import info.ata4.bspsrc.lib.struct.DOccluderPolyData;
import info.ata4.bspsrc.lib.struct.DPlane;
import info.ata4.bspsrc.lib.vector.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class WindingFactory {
    private final Map<DFace, Winding> faceCache = new HashMap<DFace, Winding>();
    private final Map<Map.Entry<DBrush, DBrushSide>, Winding> brushSideCache = new HashMap<Map.Entry<DBrush, DBrushSide>, Winding>();
    private final Map<DAreaportal, Winding> areaportalCache = new HashMap<DAreaportal, Winding>();
    private final Map<DOccluderPolyData, Winding> occluderCache = new HashMap<DOccluderPolyData, Winding>();
    private final Map<DPlane, Winding> planeCache = new HashMap<DPlane, Winding>();

    public Winding fromFace(BspData bsp, DFace face) {
        if (this.faceCache.containsKey(face)) {
            return this.faceCache.get(face);
        }
        ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
        for (int i = 0; i < face.numedge; ++i) {
            int sedge = bsp.surfEdges.get(face.fstedge + i);
            int v = sedge < 0 ? bsp.edges.get((int)(-sedge)).v[1] : bsp.edges.get((int)sedge).v[0];
            verts.add(bsp.verts.get((int)v).point);
        }
        Winding w = new Winding(verts);
        this.faceCache.put(face, w);
        return w;
    }

    public Winding fromSide(BspData bsp, DBrush brush, DBrushSide bside) {
        Map.Entry<DBrush, DBrushSide> key = Map.entry(brush, bside);
        if (this.brushSideCache.containsKey(key)) {
            return this.brushSideCache.get(key);
        }
        int iplane = bside.pnum;
        boolean hasSide = false;
        Winding w = this.fromPlane(bsp.planes.get(iplane));
        for (int i = 0; i < brush.numside; ++i) {
            int ibside2 = brush.fstside + i;
            DBrushSide bside2 = bsp.brushSides.get(ibside2);
            if (bside2 == bside) {
                hasSide = true;
                continue;
            }
            if (bside2.bevel) continue;
            int iplane2 = bside2.pnum;
            DPlane plane = bsp.planes.get(iplane2);
            DPlane flipPlane = new DPlane();
            flipPlane.normal = plane.normal.scalar(-1.0f);
            flipPlane.dist = -plane.dist;
            w = w.clipPlane(flipPlane, false);
        }
        if (!hasSide) {
            throw new IllegalArgumentException("Brush side is not part of brush!");
        }
        this.brushSideCache.put(key, w);
        return w;
    }

    public Winding fromSide(BspData bsp, DBrush brush, int side) {
        int ibside = brush.fstside + side;
        DBrushSide bside = bsp.brushSides.get(ibside);
        return this.fromSide(bsp, brush, bside);
    }

    public Winding fromAreaportal(BspData bsp, DAreaportal ap) {
        if (this.areaportalCache.containsKey(ap)) {
            return this.areaportalCache.get(ap);
        }
        Winding w = bsp.clipPortalVerts.subList(ap.firstClipPortalVert, ap.firstClipPortalVert + ap.clipPortalVerts).stream().map(dVertex -> dVertex.point).collect(Collectors.collectingAndThen(Collectors.toList(), Winding::new));
        this.areaportalCache.put(ap, w);
        return w;
    }

    public Winding fromOccluder(BspData bsp, DOccluderPolyData opd) {
        if (this.occluderCache.containsKey(opd)) {
            return this.occluderCache.get(opd);
        }
        ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
        for (int k = 0; k < opd.vertexcount; ++k) {
            int pvi = bsp.occluderVerts.get(opd.firstvertexindex + k);
            verts.add(bsp.verts.get((int)pvi).point);
        }
        Winding w = new Winding(verts);
        this.occluderCache.put(opd, w);
        return w;
    }

    public Winding fromPlane(DPlane pl) {
        if (this.planeCache.containsKey(pl)) {
            return this.planeCache.get(pl);
        }
        float dmax = -1.0f;
        int idir = -1;
        for (int i = 0; i < pl.normal.size; ++i) {
            float dc = Math.abs(pl.normal.get(i));
            if (dc <= dmax) continue;
            dmax = dc;
            idir = i;
        }
        if (idir == -1) {
            throw new RuntimeException("Plane " + String.valueOf(pl) + ": bad normal");
        }
        Vector3f vup = Vector3f.NULL;
        switch (idir) {
            case 0: 
            case 1: {
                vup = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            case 2: {
                vup = new Vector3f(1.0f, 0.0f, 0.0f);
            }
        }
        float vdot = vup.dot(pl.normal);
        vup = vup.add(pl.normal.scalar(-vdot));
        vup = vup.normalize();
        Vector3f org = pl.normal.scalar(pl.dist);
        Vector3f vrt = vup.cross(pl.normal);
        vup = vup.scalar(56756.0f);
        vrt = vrt.scalar(56756.0f);
        ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
        verts.add(org.sub(vrt).add(vup));
        verts.add(org.add(vrt).add(vup));
        verts.add(org.add(vrt).sub(vup));
        verts.add(org.sub(vrt).sub(vup));
        Winding w = new Winding(verts);
        this.planeCache.put(pl, w);
        return w;
    }
}

