/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.util;

import info.ata4.bspsrc.decompiler.util.AABB;
import info.ata4.bspsrc.lib.struct.DPlane;
import info.ata4.bspsrc.lib.vector.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Winding
implements List<Vector3f> {
    private static final Winding EMPTY = new Winding(Collections.unmodifiableList(new ArrayList()));
    public static final int MAX_LEN = 56756;
    public static final int MAX_COORD = 32768;
    public static final int SIDE_FRONT = 0;
    public static final int SIDE_BACK = 1;
    public static final int SIDE_ON = 2;
    public static final float EPS_SPLIT = 0.01f;
    public static final float EPS_COMP = 0.5f;
    public static final float EPS_DEGEN = 0.1f;
    private final List<Vector3f> verts;

    public Winding(Winding that) {
        this.verts = that.verts;
    }

    public Winding(List<Vector3f> verts) {
        this.verts = Collections.unmodifiableList(verts);
    }

    public Winding(Vector3f[] vertices) {
        this.verts = Collections.unmodifiableList(Arrays.asList(vertices));
    }

    public Winding clipEpsilon(Vector3f normal, float dist, float eps, boolean back) {
        int[] counts = new int[]{0, 0, 0};
        int size = this.verts.size();
        float[] dists = new float[size + 1];
        int[] sides = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            float dot = this.verts.get(i).dot(normal);
            dists[i] = dot -= dist;
            sides[i] = dot > eps ? 0 : (dot < -eps ? 1 : 2);
            int n = sides[i];
            counts[n] = counts[n] + 1;
        }
        sides[size] = sides[0];
        dists[size] = dists[0];
        if (counts[0] == 0) {
            if (!back) {
                if (counts[2] == 0) {
                    return EMPTY;
                }
            } else {
                return this;
            }
        }
        if (counts[1] == 0) {
            if (back) {
                if (counts[2] == 0) {
                    return EMPTY;
                }
            } else {
                return this;
            }
        }
        ArrayList<Vector3f> vertsNew = new ArrayList<Vector3f>();
        for (int i = 0; i < size; ++i) {
            Vector3f p1 = this.verts.get(i);
            if (sides[i] == 2) {
                vertsNew.add(p1);
                continue;
            }
            if (sides[i] == 0 && !back) {
                vertsNew.add(p1);
            }
            if (sides[i] == 1 && back) {
                vertsNew.add(p1);
            }
            if (sides[i + 1] == 2 || sides[i + 1] == sides[i]) continue;
            Vector3f p2 = i == size - 1 ? this.verts.get(0) : this.verts.get(i + 1);
            float dot = dists[i] / (dists[i] - dists[i + 1]);
            Vector3f mv = Vector3f.NULL;
            for (int j = 0; j < normal.size; ++j) {
                mv = normal.get(j) == 1.0f ? mv.set(j, dist) : (normal.get(j) == -1.0f ? mv.set(j, -dist) : mv.set(j, p1.get(j) + dot * (p2.get(j) - p1.get(j))));
            }
            vertsNew.add(mv);
        }
        return new Winding(vertsNew);
    }

    public Winding clipPlane(DPlane pl, boolean back) {
        return this.clipEpsilon(pl.normal, pl.dist, 0.01f, back);
    }

    public Winding clipWinding(Winding other, Vector3f projNormal) {
        if (other.size() < 3) {
            return this;
        }
        Winding result = this;
        for (int i = 0; i < other.size(); ++i) {
            Vector3f edge = other.get(i).sub(other.get((i + 1) % other.size()));
            Vector3f normal = edge.cross(projNormal).normalize();
            float dist = normal.dot(other.get(i));
            result = result.clipEpsilon(normal, dist, 0.01f, true);
        }
        return result;
    }

    public Winding removeDegenerated() {
        if (this.verts.isEmpty()) {
            return this;
        }
        ArrayList<Vector3f> vertsNew = new ArrayList<Vector3f>();
        int size = this.verts.size();
        for (int i = 0; i < size; ++i) {
            Vector3f v2;
            int j = (i + 1) % size;
            Vector3f v1 = this.verts.get(i);
            if (!(v1.sub(v2 = this.verts.get(j)).length() > 0.1f)) continue;
            vertsNew.add(v1);
        }
        return new Winding(vertsNew);
    }

    public Winding removeCollinear() {
        if (this.verts.isEmpty()) {
            return this;
        }
        ArrayList<Vector3f> vertsNew = new ArrayList<Vector3f>();
        int size = this.verts.size();
        for (int i = 0; i < size; ++i) {
            Vector3f v2;
            int j = (i + 1) % size;
            int k = (i + size - 1) % size;
            Vector3f v1 = this.verts.get(j).sub(this.verts.get(i)).normalize();
            if (!((double)v1.dot(v2 = this.verts.get(i).sub(this.verts.get(k)).normalize()) < 0.999)) continue;
            vertsNew.add(this.verts.get(i));
        }
        return new Winding(vertsNew);
    }

    public Winding rotate(Vector3f angles) {
        if (this.verts.isEmpty()) {
            return this;
        }
        ArrayList<Vector3f> vertsNew = new ArrayList<Vector3f>();
        for (Vector3f vert : this.verts) {
            vertsNew.add(vert.rotate(angles));
        }
        return new Winding(vertsNew);
    }

    public Winding translate(Vector3f offset) {
        if (this.verts.isEmpty()) {
            return this;
        }
        ArrayList<Vector3f> vertsNew = new ArrayList<Vector3f>();
        for (Vector3f vert : this.verts) {
            vertsNew.add(vert.add(offset));
        }
        return new Winding(vertsNew);
    }

    public Winding addBackface() {
        if (this.verts.isEmpty()) {
            return this;
        }
        ArrayList<Vector3f> vertsNew = new ArrayList<Vector3f>();
        int size = this.verts.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                vertsNew.add(this.verts.get(i));
            }
            if (i == size) continue;
            vertsNew.add(this.verts.get(i));
        }
        return new Winding(vertsNew);
    }

    public boolean isHuge() {
        for (Vector3f point : this) {
            for (float value : point) {
                if (!(Math.abs(value) > 32768.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(Winding that) {
        int size = this.verts.size();
        if (size != that.verts.size()) {
            return false;
        }
        for (Vector3f v1 : this.verts) {
            float min = 1000000.0f;
            for (Vector3f v2 : that.verts) {
                min = Math.min(min, v1.sub(v2).length());
            }
            if (!(min > 0.5f)) continue;
            return false;
        }
        return true;
    }

    public boolean isInside(Vector3f pt) {
        if (this.isEmpty() || this.size() < 2) {
            return false;
        }
        Vector3f toPt = pt.sub(this.get(0));
        Vector3f edge = this.get(1).sub(this.get(0));
        Vector3f testCross = edge.cross(toPt).normalize();
        int size = this.size();
        for (int i = 1; i < size; ++i) {
            toPt = pt.sub(this.get(i));
            edge = this.get((i + 1) % size).sub(this.get(i));
            Vector3f cross = edge.cross(toPt).normalize();
            if (!(cross.dot(testCross) < 0.0f)) continue;
            return false;
        }
        return true;
    }

    public AABB getBounds() {
        Vector3f mins = Vector3f.MAX_VALUE;
        Vector3f maxs = Vector3f.MIN_VALUE;
        for (Vector3f vert : this.verts) {
            mins = mins.min(vert);
            maxs = maxs.max(vert);
        }
        return new AABB(mins, maxs);
    }

    public Vector3f getCenter() {
        Vector3f sum = Vector3f.NULL;
        for (Vector3f vert : this.verts) {
            sum = sum.add(vert);
        }
        return sum.scalar(1.0f / (float)this.verts.size());
    }

    public Vector3f[] buildPlane() {
        Vector3f[] vertsNew = new Vector3f[this.verts.size()];
        Vector3f[] plane = new Vector3f[3];
        plane[0] = this.get(0);
        for (int i = 0; i < vertsNew.length; ++i) {
            vertsNew[i] = this.get(i).sub(plane[0]);
        }
        float maxmcp = -1.0f;
        int imax = -1;
        int jmax = -1;
        for (int i = 1; i < vertsNew.length; ++i) {
            for (int j = i + 1; j < vertsNew.length; ++j) {
                float mcp = vertsNew[i].cross(vertsNew[j]).length();
                if (!(mcp > maxmcp)) continue;
                maxmcp = mcp;
                imax = i;
                jmax = j;
            }
        }
        plane[1] = this.get(imax);
        plane[2] = this.get(jmax);
        return plane;
    }

    public boolean hasDuplicates() {
        int size = this.verts.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Vector3f v2;
                Vector3f v1;
                if (i == j || !(v1 = this.verts.get(i)).equals(v2 = this.verts.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public float getArea() {
        float total = 0.0f;
        int size = this.verts.size();
        for (int i = 2; i < size; ++i) {
            Vector3f v1 = this.verts.get(i - 1).sub(this.verts.get(0));
            Vector3f v2 = this.verts.get(i).sub(this.verts.get(0));
            total += v1.cross(v2).length();
        }
        return total * 0.5f;
    }

    @Override
    public int size() {
        return this.verts.size();
    }

    @Override
    public boolean isEmpty() {
        return this.verts.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.verts.contains(o);
    }

    @Override
    public Iterator<Vector3f> iterator() {
        return this.verts.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.verts.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.verts.toArray(a);
    }

    @Override
    public boolean add(Vector3f e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.verts.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Vector3f> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Vector3f> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector3f get(int index) {
        return this.verts.get(index);
    }

    @Override
    public Vector3f set(int index, Vector3f element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Vector3f element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector3f remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.verts.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.verts.lastIndexOf(o);
    }

    @Override
    public ListIterator<Vector3f> listIterator() {
        return this.verts.listIterator();
    }

    @Override
    public ListIterator<Vector3f> listIterator(int index) {
        return this.verts.listIterator(index);
    }

    @Override
    public List<Vector3f> subList(int fromIndex, int toIndex) {
        return this.verts.subList(fromIndex, toIndex);
    }

    public String toString() {
        return this.verts.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Winding other = (Winding)obj;
        return this.verts == other.verts || this.verts != null && this.verts.equals(other.verts);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.verts != null ? this.verts.hashCode() : 0);
        return hash;
    }
}

