/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.util;

import info.ata4.bspsrc.decompiler.BspSourceConfig;
import info.ata4.bspsrc.decompiler.util.BspTreeStats;
import info.ata4.bspsrc.decompiler.util.VectorUtil;
import info.ata4.bspsrc.decompiler.util.WindingFactory;
import info.ata4.bspsrc.lib.struct.BrushFlag;
import info.ata4.bspsrc.lib.struct.BspData;
import info.ata4.bspsrc.lib.struct.DBrush;
import info.ata4.bspsrc.lib.struct.DBrushSide;
import info.ata4.bspsrc.lib.struct.DOccluderData;
import info.ata4.bspsrc.lib.struct.DOccluderPolyData;
import info.ata4.bspsrc.lib.struct.DTexInfo;
import info.ata4.bspsrc.lib.struct.SurfaceFlag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OccluderMapper {
    private static final Logger L = LogManager.getLogger();
    private final WindingFactory windingFactory;
    private BspSourceConfig config;
    private BspData bsp;
    private ArrayList<DBrush> nonWorldBrushes;
    private SortedMap<Integer, Integer> potentialOccluderBrushes;
    private static final Predicate<DTexInfo> matchesOccluderTexInfo = dTexInfo -> dTexInfo.flags.equals(EnumSet.of(SurfaceFlag.SURF_NOLIGHT)) || dTexInfo.flags.equals(EnumSet.of(SurfaceFlag.SURF_TRIGGER, SurfaceFlag.SURF_NOLIGHT));

    public OccluderMapper(BspData bsp, BspSourceConfig config, WindingFactory windingFactory) {
        this.config = Objects.requireNonNull(config);
        this.bsp = Objects.requireNonNull(bsp);
        this.windingFactory = Objects.requireNonNull(windingFactory);
        this.prepareNonWorldBrushes();
        this.preparePotentialOccBrushes();
    }

    private void prepareNonWorldBrushes() {
        BspTreeStats tree = new BspTreeStats(this.bsp);
        tree.walk(0);
        this.nonWorldBrushes = new ArrayList<DBrush>(this.bsp.brushes.subList(tree.getMaxBrushLeaf() + 1, this.bsp.brushes.size()));
    }

    private void preparePotentialOccBrushes() {
        this.potentialOccluderBrushes = this.nonWorldBrushes.stream().filter(dBrush -> dBrush.contents.equals(EnumSet.of(BrushFlag.CONTENTS_SOLID))).collect(Collectors.toMap(this.bsp.brushes::indexOf, dBrush -> (int)this.bsp.brushSides.subList(dBrush.fstside, dBrush.fstside + dBrush.numside).stream().map(dBrushSide -> this.bsp.texinfos.get(dBrushSide.texinfo)).filter(matchesOccluderTexInfo).count(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, TreeMap::new));
        this.potentialOccluderBrushes.values().removeIf(faceCount -> faceCount == 0);
    }

    private Map<Integer, Set<Integer>> manualMapping() {
        Map<Integer, Set<Integer>> occBrushMapping = this.bsp.occluderDatas.stream().collect(Collectors.toMap(dOccluderData -> this.bsp.occluderDatas.indexOf(dOccluderData), this::mapOccluder));
        occBrushMapping.values().removeIf(list -> list.size() == 0);
        return occBrushMapping;
    }

    private Set<Integer> mapOccluder(DOccluderData dOccluderData) {
        return this.bsp.occluderPolyDatas.subList(dOccluderData.firstpoly, dOccluderData.firstpoly + dOccluderData.polycount).stream().map(dOccluderPolyData -> this.nonWorldBrushes.stream().filter(dBrush -> this.bsp.brushSides.subList(dBrush.fstside, dBrush.fstside + dBrush.numside).stream().anyMatch(brushSide -> this.occFacesContainsBrushFace((DOccluderPolyData)dOccluderPolyData, (DBrush)dBrush, (DBrushSide)brushSide))).findAny()).filter(Optional::isPresent).map(optionalDBrush -> this.bsp.brushes.indexOf(optionalDBrush.get())).filter(index -> {
            assert (index != -1);
            return index != -1;
        }).collect(Collectors.toSet());
    }

    private boolean occFacesContainsBrushFace(DOccluderPolyData dOccluderPolyData, DBrush dBrush, DBrushSide dBrushSide) {
        return VectorUtil.matchingAreaPercentage(dOccluderPolyData, dBrush, dBrushSide, this.bsp, this.windingFactory) > 0.0;
    }

    private Map<Integer, Set<Integer>> orderedMapping() {
        List reverseOccluderFaces = this.bsp.occluderDatas.stream().flatMap(dOccluderData -> IntStream.range(0, dOccluderData.polycount).mapToObj(value -> this.bsp.occluderDatas.indexOf(dOccluderData))).collect(Collectors.toList());
        List reverseBrushFaces = this.potentialOccluderBrushes.entrySet().stream().flatMap(entry -> LongStream.range(0L, ((Integer)entry.getValue()).intValue()).mapToObj(value -> (Integer)entry.getKey())).sorted().collect(Collectors.toList());
        int min = Math.min(reverseOccluderFaces.size(), reverseBrushFaces.size());
        return IntStream.range(0, min).boxed().collect(Collectors.groupingBy(reverseOccluderFaces::get, Collectors.collectingAndThen(Collectors.toSet(), indices -> indices.stream().map(reverseBrushFaces::get).collect(Collectors.toSet()))));
    }

    public Map<Integer, Set<Integer>> getOccBrushMapping() {
        int occluderBrushFacesNum;
        if (!this.config.writeOccluders) {
            return Collections.emptyMap();
        }
        if (this.bsp.occluderDatas.size() == 0) {
            L.info("No occluders to reallocate...");
            return Collections.emptyMap();
        }
        if (this.config.occForceManualMapping) {
            L.info("Forced manual occluder mapping method");
            return OccMappingMode.MANUAL.map(this);
        }
        int occluderFacesNum = this.potentialOccluderBrushes.values().stream().mapToInt(i -> i).sum();
        if (occluderFacesNum == (occluderBrushFacesNum = this.bsp.occluderDatas.stream().mapToInt(occluder -> occluder.polycount).sum())) {
            L.info("Equal amount of occluder faces and occluder brush faces. Using '" + String.valueOf((Object)OccMappingMode.ORDERED) + "' method");
            return OccMappingMode.ORDERED.map(this);
        }
        L.info("Unequal amount of occluder faces and occluder brush faces. Falling back to '" + String.valueOf((Object)OccMappingMode.MANUAL) + "' method");
        return OccMappingMode.MANUAL.map(this);
    }

    public static enum OccMappingMode {
        MANUAL(OccluderMapper::manualMapping),
        ORDERED(OccluderMapper::orderedMapping);

        private Function<OccluderMapper, Map<Integer, Set<Integer>>> mapper;

        private OccMappingMode(Function<OccluderMapper, Map<Integer, Set<Integer>>> mapper) {
            this.mapper = mapper;
        }

        public Map<Integer, Set<Integer>> map(OccluderMapper occMapper) {
            return this.mapper.apply(occMapper);
        }

        public String toString() {
            return super.toString().substring(0, 1).toUpperCase() + super.toString().substring(1).toLowerCase();
        }
    }
}

