/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.util;

import info.ata4.bspsrc.lib.vector.Vector3f;

public class AABB {
    public static final AABB ZERO = new AABB(Vector3f.MAX_VALUE, Vector3f.MIN_VALUE);
    private final Vector3f min;
    private final Vector3f max;

    public AABB(Vector3f mins, Vector3f maxs) {
        this.min = mins;
        this.max = maxs;
    }

    public Vector3f getMin() {
        return this.min;
    }

    public Vector3f getMax() {
        return this.max;
    }

    public Vector3f getSize() {
        return this.max.sub(this.min);
    }

    public boolean intersectsWith(AABB that) {
        return that.max.x > this.min.x && that.min.x < this.max.x && that.max.y > this.min.y && that.min.y < this.max.y && that.max.z > this.min.z && that.min.z < this.max.z;
    }

    public AABB include(AABB that) {
        return new AABB(this.min.min(that.min), this.max.max(that.max));
    }

    public AABB expand(Vector3f v) {
        return new AABB(this.min.sub(v), this.max.add(v));
    }

    public AABB expand(float e) {
        return this.expand(new Vector3f(e, e, e));
    }

    public String toString() {
        return this.min.toString() + " -> " + this.max.toString();
    }
}

