/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules.entity;

import info.ata4.bspsrc.decompiler.BspSourceConfig;
import info.ata4.bspsrc.decompiler.VmfWriter;
import info.ata4.bspsrc.decompiler.modules.BspProtection;
import info.ata4.bspsrc.decompiler.modules.ModuleDecompile;
import info.ata4.bspsrc.decompiler.modules.VmfMeta;
import info.ata4.bspsrc.decompiler.modules.entity.Camera;
import info.ata4.bspsrc.decompiler.modules.geom.BrushBounds;
import info.ata4.bspsrc.decompiler.modules.geom.BrushMode;
import info.ata4.bspsrc.decompiler.modules.geom.BrushSideFaceMapper;
import info.ata4.bspsrc.decompiler.modules.geom.BrushSource;
import info.ata4.bspsrc.decompiler.modules.geom.FaceSource;
import info.ata4.bspsrc.decompiler.modules.texture.TextureSource;
import info.ata4.bspsrc.decompiler.util.AABB;
import info.ata4.bspsrc.decompiler.util.AreaportalMapper;
import info.ata4.bspsrc.decompiler.util.OccluderMapper;
import info.ata4.bspsrc.decompiler.util.SourceFormat;
import info.ata4.bspsrc.decompiler.util.Winding;
import info.ata4.bspsrc.decompiler.util.WindingFactory;
import info.ata4.bspsrc.lib.BspFileReader;
import info.ata4.bspsrc.lib.entity.Entity;
import info.ata4.bspsrc.lib.entity.KeyValue;
import info.ata4.bspsrc.lib.nmo.NmoAntiObjective;
import info.ata4.bspsrc.lib.nmo.NmoFile;
import info.ata4.bspsrc.lib.nmo.NmoObjective;
import info.ata4.bspsrc.lib.struct.Color32;
import info.ata4.bspsrc.lib.struct.DBrush;
import info.ata4.bspsrc.lib.struct.DBrushSide;
import info.ata4.bspsrc.lib.struct.DCubemapSample;
import info.ata4.bspsrc.lib.struct.DFace;
import info.ata4.bspsrc.lib.struct.DOverlay;
import info.ata4.bspsrc.lib.struct.DOverlayFade;
import info.ata4.bspsrc.lib.struct.DOverlaySystemLevel;
import info.ata4.bspsrc.lib.struct.DStaticProp;
import info.ata4.bspsrc.lib.struct.DStaticPropV10;
import info.ata4.bspsrc.lib.struct.DStaticPropV10CSGO;
import info.ata4.bspsrc.lib.struct.DStaticPropV11CSGO;
import info.ata4.bspsrc.lib.struct.DStaticPropV11lite;
import info.ata4.bspsrc.lib.struct.DStaticPropV4;
import info.ata4.bspsrc.lib.struct.DStaticPropV5;
import info.ata4.bspsrc.lib.struct.DStaticPropV5Ship;
import info.ata4.bspsrc.lib.struct.DStaticPropV6;
import info.ata4.bspsrc.lib.struct.DStaticPropV7L4D;
import info.ata4.bspsrc.lib.struct.DStaticPropV8;
import info.ata4.bspsrc.lib.struct.DStaticPropV9;
import info.ata4.bspsrc.lib.struct.DStaticPropVinScaling;
import info.ata4.bspsrc.lib.vector.Vector3f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntitySource
extends ModuleDecompile {
    private static final Logger L = LogManager.getLogger();
    private static final Pattern INSTANCE_PREFIX = Pattern.compile("^([^-]+)-");
    private final WindingFactory windingFactory;
    private final BrushBounds brushBounds;
    private final BspSourceConfig config;
    private final BrushSource brushsrc;
    private final FaceSource facesrc;
    private final TextureSource texsrc;
    private final BspProtection bspprot;
    private final VmfMeta vmfmeta;
    private final BrushSideFaceMapper brushSideFaceMapper;
    private final AreaportalMapper areaportalMapper;
    private final Map<Integer, Integer> apBrushMap;
    private final OccluderMapper occluderMapper;
    private final Map<Integer, Set<Integer>> occBrushesMap;
    private NmoFile nmo;
    private final Map<Integer, String> overlayNames = new HashMap<Integer, String>();

    public EntitySource(BspFileReader reader, VmfWriter writer, BspSourceConfig config, BrushSource brushsrc, FaceSource facesrc, TextureSource texsrc, BspProtection bspprot, VmfMeta vmfmeta, BrushSideFaceMapper brushSideFaceMapper, WindingFactory windingFactory, BrushBounds brushBounds) {
        super(reader, writer);
        this.config = Objects.requireNonNull(config);
        this.brushsrc = Objects.requireNonNull(brushsrc);
        this.facesrc = Objects.requireNonNull(facesrc);
        this.texsrc = Objects.requireNonNull(texsrc);
        this.bspprot = Objects.requireNonNull(bspprot);
        this.vmfmeta = Objects.requireNonNull(vmfmeta);
        this.brushSideFaceMapper = Objects.requireNonNull(brushSideFaceMapper);
        this.windingFactory = Objects.requireNonNull(windingFactory);
        this.brushBounds = Objects.requireNonNull(brushBounds);
        this.processEntities();
        this.areaportalMapper = new AreaportalMapper(this.bsp, config, windingFactory);
        this.apBrushMap = this.areaportalMapper.getApBrushMapping();
        this.occluderMapper = new OccluderMapper(this.bsp, config, windingFactory);
        this.occBrushesMap = this.occluderMapper.getOccBrushMapping();
        this.occBrushesMap.values().forEach(brushIndexes -> brushIndexes.forEach(index -> this.bsp.brushes.get((int)index).flagAsOccluder(true)));
    }

    public void writeEntities() {
        L.info("Writing entities");
        boolean instances = this.bspFile.getVersion() >= 21;
        boolean fixRot = this.config.fixEntityRot && instances;
        VmfMeta.Visgroup reallocatedVg = this.vmfmeta.visgroups().getVisgroup("Reallocated").setColor(Color.GREEN);
        VmfMeta.Visgroup rebuildVg = this.vmfmeta.visgroups().getVisgroup("Rebuild").setColor(Color.RED);
        VmfMeta.Visgroup reallocatedAreaportalVg = reallocatedVg.getVisgroup("Areaportal").setColor(Color.CYAN);
        VmfMeta.Visgroup rebuildAreaportalVg = rebuildVg.getVisgroup("Areaportal").setColor(Color.CYAN.darker());
        VmfMeta.Visgroup reallocatedOccluderVg = reallocatedVg.getVisgroup("Occluder").setColor(Color.MAGENTA);
        VmfMeta.Visgroup rebuildOccluderVg = rebuildVg.getVisgroup("Occluder").setColor(Color.MAGENTA.darker());
        ArrayList<VmfMeta.Visgroup> visgroups = new ArrayList<VmfMeta.Visgroup>();
        for (Entity ent : this.bsp.entities) {
            Matcher m;
            Vector3f angles;
            Object value;
            String oidStr;
            boolean hasBrush;
            String model;
            visgroups.clear();
            String className = ent.getClassName();
            if (className.equals("worldspawn")) continue;
            if (className.equals("env_sprite") && (model = ent.getValue("model")) != null && model.startsWith("model")) {
                ent.removeValue("scale");
            }
            boolean isAreaportal = className.startsWith("func_areaportal");
            boolean isOccluder = className.equals("func_occluder");
            boolean bl = hasBrush = ent.getModelNum() > 0 || isAreaportal || isOccluder;
            if (!this.config.writePointEntities && !hasBrush || !this.config.writeBrushEntities && hasBrush || !this.config.writeAreaportals && isAreaportal || !this.config.writeOccluders && isOccluder || className.equals("info_ladder")) continue;
            if (className.equals("info_overlay_accessor") && (oidStr = ent.getValue("OverlayID")) != null && !oidStr.isEmpty()) {
                int oid = Integer.valueOf(oidStr);
                this.overlayNames.put(oid, ent.getTargetName());
                continue;
            }
            int portalNum = -1;
            if (isAreaportal) {
                String portalNumString = ent.getValue("portalnumber");
                if (portalNumString == null) {
                    L.warn(String.format("%s is missing 'portalnumber' attribute, skipping...", className));
                    continue;
                }
                try {
                    portalNum = Integer.parseInt(portalNumString);
                }
                catch (NumberFormatException e) {
                    L.warn(String.format("Can't parse %s 'portalnumber' attribute: '%s', skipping...", className, portalNumString));
                    continue;
                }
                if (!this.areaportalMapper.hasValidGeometry(portalNum)) {
                    L.warn(String.format("%s links to non existing areaportal or has invalid geometry, skipping...", className));
                    continue;
                }
                if (!this.config.debug) {
                    ent.removeValue("portalnumber");
                }
            }
            int occluderNum = -1;
            if (isOccluder) {
                String occluderNumString = ent.getValue("occludernumber");
                if (occluderNumString == null) {
                    L.warn(String.format("%s is missing 'occludernumber' attribute, skipping...", className));
                    continue;
                }
                try {
                    occluderNum = Integer.parseInt(occluderNumString);
                }
                catch (NumberFormatException ex) {
                    L.warn(String.format("Can't parse %s 'occludernumber' attribute: '%s', skipping...", className, occluderNumString));
                    continue;
                }
                if (!this.config.debug) {
                    ent.removeValue("occludernumber");
                }
            }
            int entID = this.getHammerID(ent);
            if (this.nmo != null) {
                entID = this.nmo.extractions.stream().filter(extraction -> extraction.name.equals(ent.getTargetName())).findAny().map(extraction -> extraction.id).orElse(entID);
            }
            if (entID == -1) {
                entID = this.vmfmeta.getUID();
            }
            this.writer.start("entity");
            this.writer.put("id", entID);
            int modelNum = ent.getModelNum();
            for (Map.Entry<String, String> entry : ent.getEntrySet()) {
                String key = entry.getKey();
                value = entry.getValue();
                if (key.equals("angles") && modelNum >= 0 && fixRot || key.equals("origin") && modelNum == 0 || key.equals("model") && modelNum != -2 || key.equals("hammerid") || (isAreaportal || isOccluder) && (key.equals("angles") || key.equals("origin"))) continue;
                this.writer.put(key, value);
            }
            this.writer.put("classname", className);
            List<KeyValue> io = ent.getIO();
            if (!io.isEmpty()) {
                this.writer.start("connections");
                for (KeyValue kv2 : io) {
                    this.writer.put(kv2);
                }
                this.writer.end("connections");
            }
            Vector3f vector3f = ent.getOrigin();
            Vector3f vector3f2 = angles = fixRot ? ent.getAngles() : null;
            if (modelNum > 0) {
                if (this.config.brushMode == BrushMode.BRUSHPLANES) {
                    this.brushsrc.writeModel(modelNum, vector3f, angles);
                } else {
                    this.facesrc.writeModel(modelNum, vector3f, angles);
                }
            } else {
                if (isAreaportal && portalNum != -1) {
                    if (this.config.brushMode == BrushMode.BRUSHPLANES && this.apBrushMap.containsKey(portalNum)) {
                        this.brushsrc.writeBrush(this.apBrushMap.get(portalNum));
                        visgroups.add(reallocatedAreaportalVg);
                    } else {
                        this.facesrc.writeAreaportal(portalNum);
                        visgroups.add(rebuildAreaportalVg);
                    }
                    if (this.config.debug) {
                        visgroups.add(this.vmfmeta.visgroups().getVisgroup("AreaportalID").getVisgroup(String.valueOf(portalNum)));
                    }
                }
                if (isOccluder && occluderNum != -1) {
                    if (this.config.brushMode == BrushMode.BRUSHPLANES && this.occBrushesMap.containsKey(occluderNum)) {
                        value = this.occBrushesMap.get(occluderNum).iterator();
                        while (value.hasNext()) {
                            int brushId = (Integer)value.next();
                            this.brushsrc.writeBrush(brushId);
                        }
                        visgroups.add(reallocatedOccluderVg);
                    } else {
                        this.facesrc.writeOccluder(occluderNum);
                        visgroups.add(rebuildOccluderVg);
                    }
                }
            }
            if (instances && ent.getTargetName() != null && (m = INSTANCE_PREFIX.matcher(ent.getTargetName())).find()) {
                visgroups.add(this.vmfmeta.visgroups().getVisgroup("Instances").getVisgroup(m.group(1)));
            }
            if (this.bspprot.isProtectedEntity(ent)) {
                visgroups.add(this.vmfmeta.visgroups().getVisgroup("VMEX flagged entities"));
            }
            if (this.nmo != null && ent.getTargetName() != null) {
                this.nmo.nodes.stream().filter(objective -> Stream.concat(objective.entities.stream(), Stream.of(objective.entityName)).anyMatch(entitiyName -> entitiyName.equals(ent.getTargetName()))).forEach(objective -> visgroups.add(this.vmfmeta.visgroups().getVisgroup("Objectives").getVisgroup(objective.name)));
                this.nmo.antiNodes.stream().filter(anti -> anti.entities.stream().anyMatch(entitiyName -> entitiyName.equals(ent.getTargetName()))).forEach(anti -> visgroups.add(this.vmfmeta.visgroups().getVisgroup("Objectives").getVisgroup("anti").getVisgroup(anti.name)));
            }
            if (!visgroups.isEmpty()) {
                this.vmfmeta.writeMetaVisgroups(visgroups);
            }
            this.writer.end("entity");
        }
        if (this.config.debug) {
            this.areaportalMapper.writeDebugPortals(this.writer, this.vmfmeta, this.facesrc);
        }
    }

    public void writeDetails() {
        Set funcDetailBrushGroups;
        L.info("Writing func_details");
        Set funcDetailBrushes = this.bsp.brushes.stream().filter(this.brushsrc::isFuncDetail).filter(dBrush -> !this.bspprot.isProtectedBrush((DBrush)dBrush)).collect(Collectors.toSet());
        if (this.config.detailMerge) {
            int newGroupId = 0;
            HashMap<DBrush, Integer> brushGroups = new HashMap<DBrush, Integer>();
            for (DBrush funcDetailBrush : funcDetailBrushes) {
                AABB bounds = this.brushBounds.getBounds(this.bsp, funcDetailBrush);
                AABB extendedBounds = bounds.expand(this.config.detailMergeThresh);
                HashSet intersectingGroupIds = new HashSet();
                brushGroups.forEach((dBrush, groupId) -> {
                    AABB otherBrushBounds;
                    if (!intersectingGroupIds.contains(groupId) && extendedBounds.intersectsWith(otherBrushBounds = this.brushBounds.getBounds(this.bsp, (DBrush)dBrush))) {
                        intersectingGroupIds.add(groupId);
                    }
                });
                if (!intersectingGroupIds.isEmpty()) {
                    int finalNewGroupId = newGroupId;
                    brushGroups.replaceAll((dBrush, groupId) -> intersectingGroupIds.contains(groupId) ? finalNewGroupId : groupId);
                }
                brushGroups.put(funcDetailBrush, newGroupId++);
            }
            HashMap inverseBrushGroups = new HashMap();
            brushGroups.forEach((dBrush, groupId) -> inverseBrushGroups.computeIfAbsent(groupId, HashSet::new).add(dBrush));
            funcDetailBrushGroups = new HashSet(inverseBrushGroups.values());
        } else {
            funcDetailBrushGroups = funcDetailBrushes.stream().map(Collections::singleton).collect(Collectors.toSet());
        }
        for (Set funcDetailBrushGroup : funcDetailBrushGroups) {
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "func_detail");
            funcDetailBrushGroup.stream().map(this.bsp.brushes::indexOf).forEach(this.brushsrc::writeBrush);
            this.writer.end("entity");
        }
        List<DBrush> protBrushes = this.bspprot.getProtectedBrushes();
        if (!protBrushes.isEmpty()) {
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "func_detail");
            this.vmfmeta.writeMetaVisgroup("VMEX protector brushes");
            for (DBrush protBrush : protBrushes) {
                this.brushsrc.writeBrush(this.bsp.brushes.indexOf(protBrush));
            }
            this.writer.end("entity");
        }
    }

    public void writeOverlays() {
        L.info("Writing info_overlays");
        for (int i = 0; i < this.bsp.overlays.size(); ++i) {
            DOverlay o = this.bsp.overlays.get(i);
            Vector3f ubasis = new Vector3f(o.uvpoints[0].z, o.uvpoints[1].z, o.uvpoints[2].z);
            boolean vflip = o.uvpoints[3].z == 1.0f;
            for (int j = 0; j < 4; ++j) {
                o.uvpoints[j] = o.uvpoints[j].set(2, 0.0f);
            }
            Vector3f vbasis = o.basisNormal.cross(ubasis).normalize();
            if (vflip) {
                vbasis = vbasis.scalar(-1.0f);
            }
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "info_overlay");
            this.writer.put("material", this.texsrc.getTextureName(o.texinfo));
            this.writer.put("StartU", o.u[0]);
            this.writer.put("EndU", o.u[1]);
            this.writer.put("StartV", o.v[0]);
            this.writer.put("EndV", o.v[1]);
            this.writer.put("BasisOrigin", o.origin);
            this.writer.put("BasisU", ubasis);
            this.writer.put("BasisV", vbasis);
            this.writer.put("BasisNormal", o.basisNormal);
            this.writer.put("origin", o.origin);
            if (this.bsp.overlayFades != null && !this.bsp.overlayFades.isEmpty()) {
                DOverlayFade of = this.bsp.overlayFades.get(i);
                this.writer.put("fademindist", of.fadeDistMinSq);
                this.writer.put("fademaxdist", of.fadeDistMaxSq);
            }
            if (this.bsp.overlaySysLevels != null && !this.bsp.overlaySysLevels.isEmpty()) {
                DOverlaySystemLevel osl = this.bsp.overlaySysLevels.get(i);
                this.writer.put("mincpulevel", osl.minCPULevel);
                this.writer.put("maxcpulevel", osl.maxCPULevel);
                this.writer.put("mingpulevel", osl.minGPULevel);
                this.writer.put("maxgpulevel", osl.maxGPULevel);
            }
            for (int j = 0; j < 4; ++j) {
                this.writer.put("uv" + j, o.uvpoints[j]);
            }
            this.writer.put("RenderOrder", o.getRenderOrder());
            HashSet<Integer> sides = new HashSet<Integer>();
            int faceCount = o.getFaceCount();
            if (this.config.brushMode == BrushMode.BRUSHPLANES) {
                for (j = 0; j < faceCount; ++j) {
                    DFace dFace = this.bsp.faces.get(o.ofaces[j]);
                    if (dFace.dispInfo >= 0) {
                        sides.add(this.vmfmeta.getDispInfoUID(dFace.dispInfo));
                        continue;
                    }
                    int origFaceI = dFace.origFace;
                    if (origFaceI < 0) continue;
                    for (int brushSideI : this.brushSideFaceMapper.getBrushSideIndices(origFaceI)) {
                        sides.add(this.brushsrc.getBrushSideIDForIndex(brushSideI));
                    }
                }
            } else {
                for (j = 0; j < faceCount; ++j) {
                    int iface = o.ofaces[j];
                    int faceId = this.vmfmeta.getFaceUID(iface);
                    if (faceId == -1) continue;
                    sides.add(faceId);
                }
            }
            this.writer.put("sides", sides.stream().map(String::valueOf).collect(Collectors.joining(" ")));
            if (this.overlayNames.containsKey(o.id)) {
                this.writer.put("targetname", this.overlayNames.get(o.id));
            }
            this.writer.end("entity");
        }
    }

    public void writeStaticProps() {
        L.info("Writing prop_statics");
        LinkedHashMap<Vector3f, Object> lightingOrigins = new LinkedHashMap<Vector3f, Object>();
        for (DStaticProp dStaticProp : this.bsp.staticProps) {
            DStaticPropV4 pst4 = (DStaticPropV4)dStaticProp;
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "prop_static");
            this.writer.put("origin", pst4.origin);
            this.writer.put("angles", pst4.angles);
            this.writer.put("skin", pst4.skin);
            this.writer.put("fademindist", pst4.fademin == 0.0f ? -1.0f : pst4.fademin);
            this.writer.put("fademaxdist", pst4.fademax);
            this.writer.put("solid", pst4.solid);
            this.writer.put("model", this.bsp.staticPropName.get(pst4.propType));
            this.writer.put("screenspacefade", pst4.hasScreenSpaceFadeInPixels());
            this.writer.put("ignorenormals", pst4.hasIgnoreNormals());
            this.writer.put("disableselfshadowing", pst4.hasNoSelfShadowing());
            this.writer.put("disablevertexlighting", pst4.hasNoPerVertexLighting());
            if (pst4.usesLightingOrigin()) {
                Object infoLightingName;
                if (lightingOrigins.containsKey(pst4.lightingOrigin)) {
                    infoLightingName = (String)lightingOrigins.get(pst4.lightingOrigin);
                } else {
                    infoLightingName = "sprp_lighting_" + lightingOrigins.size();
                    lightingOrigins.put(pst4.lightingOrigin, infoLightingName);
                }
                this.writer.put("lightingorigin", infoLightingName);
            }
            this.writer.put("disableshadows", pst4.hasNoShadowing());
            if (dStaticProp instanceof DStaticPropV5) {
                DStaticPropV5 pst5 = (DStaticPropV5)dStaticProp;
                this.writer.put("fadescale", pst5.forcedFadeScale);
            }
            if (dStaticProp instanceof DStaticPropV6) {
                DStaticPropV6 pst6 = (DStaticPropV6)dStaticProp;
                this.writer.put("maxdxlevel", pst6.maxDXLevel);
                this.writer.put("mindxlevel", pst6.minDXLevel);
            }
            if (dStaticProp instanceof DStaticPropVinScaling) {
                this.writer.put("scale", ((DStaticPropVinScaling)((Object)dStaticProp)).getScaling());
            }
            Color32 diffMod = null;
            if (dStaticProp instanceof DStaticPropV7L4D) {
                DStaticPropV7L4D pst7 = (DStaticPropV7L4D)dStaticProp;
                diffMod = pst7.diffuseModulation;
            }
            if (dStaticProp instanceof DStaticPropV8) {
                DStaticPropV8 pst8 = (DStaticPropV8)dStaticProp;
                diffMod = pst8.diffuseModulation;
                this.writer.put("maxcpulevel", pst8.maxCPULevel);
                this.writer.put("mincpulevel", pst8.minCPULevel);
                this.writer.put("maxgpulevel", pst8.maxGPULevel);
                this.writer.put("mingpulevel", pst8.minGPULevel);
            }
            if (diffMod != null) {
                this.writer.put("rendercolor", String.format("%d %d %d", diffMod.r, diffMod.g, diffMod.b));
                this.writer.put("renderamt", diffMod.a);
            }
            if (dStaticProp instanceof DStaticPropV9) {
                DStaticPropV9 pst9 = (DStaticPropV9)dStaticProp;
                this.writer.put("disableX360", pst9.disableX360);
            }
            if (dStaticProp instanceof DStaticPropV5Ship) {
                this.writer.put("targetname", ((DStaticPropV5Ship)dStaticProp).targetname);
            }
            if (dStaticProp instanceof DStaticPropV10) {
                DStaticPropV10 pst10 = (DStaticPropV10)dStaticProp;
                boolean genLightmaps = !pst10.hasNoPerTexelLighting();
                this.writer.put("generatelightmaps", genLightmaps);
                if (genLightmaps) {
                    this.writer.put("lightmapresolutionx", pst10.lightmapResolutionX);
                    this.writer.put("lightmapresolutiony", pst10.lightmapResolutionY);
                }
            }
            if (dStaticProp instanceof DStaticPropV11lite) {
                DStaticPropV11lite pst11 = (DStaticPropV11lite)dStaticProp;
                if (pst11.diffuseModulation.rgba != -1) {
                    diffMod = pst11.diffuseModulation;
                    this.writer.put("rendercolor", String.format("%d %d %d", diffMod.r, diffMod.g, diffMod.b));
                    this.writer.put("renderamt", diffMod.a);
                }
            }
            if (dStaticProp instanceof DStaticPropV10CSGO) {
                this.writer.put("drawinfastreflection", ((DStaticPropV10CSGO)dStaticProp).hasRenderInFastReflection());
            }
            if (dStaticProp instanceof DStaticPropV11CSGO) {
                this.writer.put("uniformscale", ((DStaticPropV11CSGO)dStaticProp).uniformScale);
            }
            this.writer.end("entity");
        }
        for (Vector3f vector3f : lightingOrigins.keySet()) {
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "info_lighting");
            this.writer.put("targetname", lightingOrigins.get(vector3f));
            this.writer.put("origin", vector3f);
            this.writer.end("entity");
        }
    }

    public void writeCubemaps() {
        L.info("Writing env_cubemaps");
        for (int i = 0; i < this.bsp.cubemaps.size(); ++i) {
            DCubemapSample cm = this.bsp.cubemaps.get(i);
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "env_cubemap");
            this.writer.put("origin", new Vector3f(cm.origin[0], cm.origin[1], cm.origin[2]));
            this.writer.put("cubemapsize", cm.size);
            Set<Integer> sideList = this.texsrc.getBrushSidesForCubemap(i);
            if (sideList != null) {
                int cmSides = sideList.size();
                if (cmSides > this.config.maxCubemapSides) {
                    L.trace("Cubemap {} has too many sides: {}", (Object)i, (Object)sideList);
                }
                if (cmSides > 0 && cmSides < this.config.maxCubemapSides) {
                    this.writer.put("sides", sideList.stream().map(String::valueOf).collect(Collectors.joining(" ")));
                }
            }
            this.writer.end("entity");
        }
    }

    public void writeLadders() {
        L.info("Writing func_ladders");
        for (int i = 0; i < this.brushsrc.getWorldbrushes(); ++i) {
            DBrush brush = this.bsp.brushes.get(i);
            if (!brush.isLadder()) continue;
            this.writer.start("entity");
            this.writer.put("id", this.vmfmeta.getUID());
            this.writer.put("classname", "func_ladder");
            this.brushsrc.writeBrush(i);
            this.writer.end("entity");
        }
    }

    private void findOverlayFaces(int ioverlay, int ioface, Set<Integer> sides) {
        if (this.bsp.origFaces.isEmpty()) {
            return;
        }
        if (sides.size() >= this.config.maxOverlaySides) {
            return;
        }
        int sidesPrev = sides.size();
        DFace origFace = this.bsp.origFaces.get(ioface);
        if (origFace.dispInfo != -1) {
            int side = this.vmfmeta.getDispInfoUID(origFace.dispInfo);
            if (side != -1) {
                L.trace("O: {} D: {} id: {}", (Object)ioverlay, (Object)origFace.dispInfo, (Object)side);
                sides.add(side);
            }
            return;
        }
        Winding wof = this.windingFactory.fromFace(this.bsp, origFace);
        block0: for (int i = 0; i < this.bsp.brushes.size(); ++i) {
            DBrush brush = this.bsp.brushes.get(i);
            for (int j = 0; j < brush.numside; ++j) {
                int ibs = brush.fstside + j;
                int side = this.brushsrc.getBrushSideIDForIndex(ibs);
                if (side == -1) continue;
                DBrushSide bs = this.bsp.brushSides.get(ibs);
                Winding w = this.windingFactory.fromSide(this.bsp, brush, j);
                if (origFace.pnum != bs.pnum || origFace.texinfo != bs.texinfo || !w.matches(wof)) continue;
                L.trace("O: {} OF: {} B: {} BS: {} id: {}", (Object)ioverlay, (Object)ioface, (Object)i, (Object)ibs, (Object)side);
                sides.add(side);
                if (sides.size() < this.config.maxOverlaySides) continue;
                L.warn("Too many brush sides for overlay {}", (Object)ioverlay);
                continue block0;
            }
        }
        if (sides.size() == sidesPrev) {
            L.trace("O: {} OF: {} no match", (Object)ioverlay, (Object)ioface);
        }
    }

    private void processEntities() {
        for (Entity ent : this.bsp.entities) {
            int hammerid;
            String className = ent.getClassName();
            if (className.equals("worldspawn")) {
                ent.removeValue("world_mins");
                ent.removeValue("world_maxs");
                ent.removeValue("hammerid");
                if (!ent.hasKey("mapversion")) {
                    ent.setValue("mapversion", this.bspFile.getRevision());
                }
            }
            if (this.config.sourceFormat != SourceFormat.AUTO) {
                char dstSep;
                char srcSep;
                if (this.config.sourceFormat == SourceFormat.NEW) {
                    srcSep = ',';
                    dstSep = '\u001b';
                } else {
                    srcSep = '\u001b';
                    dstSep = ',';
                }
                for (KeyValue kv : ent.getIO()) {
                    String value = kv.getValue();
                    value = value.replace(srcSep, dstSep);
                    kv.setValue(value);
                }
            }
            if (this.bspFile.getAppId() == 2600) {
                String value;
                for (Map.Entry<String, String> kv : ent.getEntrySet()) {
                    value = kv.getValue();
                    value = value.replace("\\\"", "");
                    kv.setValue(value);
                }
                for (KeyValue kv : ent.getIO()) {
                    value = kv.getValue();
                    value = value.replace("\\\"", "");
                    kv.setValue(value);
                }
            }
            if (className.equals("func_simpleladder")) {
                int modelNum = ent.getModelNum();
                String hammerId = ent.getValue("hammerid");
                ent.clear();
                ent.setClassName("func_ladder");
                ent.setModelNum(modelNum);
                if (hammerId != null) {
                    ent.setValue("hammerid", hammerId);
                }
            }
            if (className.startsWith("light") && !className.equals("light_dynamic")) {
                this.fixLightEntity(ent);
            }
            if (className.startsWith("info_player_")) {
                this.createCamera(ent);
            }
            if ((hammerid = this.getHammerID(ent)) == -1) continue;
            this.vmfmeta.getUIDBlackList().add(hammerid);
        }
    }

    private int getHammerID(Entity ent) {
        String keyName = "hammerid";
        if (!ent.hasKey(keyName)) {
            return -1;
        }
        String hammeridStr = ent.getValue(keyName);
        int hammerid = -1;
        try {
            hammerid = Integer.parseInt(ent.getValue("hammerid"));
        }
        catch (NumberFormatException ex) {
            L.warn("Invalid hammerid format {}", (Object)hammeridStr);
        }
        return hammerid;
    }

    private void fixLightEntity(Entity ent) {
        String style = ent.getValue("style");
        String defaultStyle = ent.getValue("defaultstyle");
        if (style == null) {
            return;
        }
        try {
            if (Integer.valueOf(style) < 32) {
                return;
            }
        }
        catch (NumberFormatException ex) {
            L.warn("Invalid light style number format: {}", (Object)style);
        }
        if (defaultStyle != null) {
            ent.setValue("style", defaultStyle);
            ent.removeValue("defaultstyle");
        } else {
            ent.removeValue("style");
        }
    }

    private void createCamera(Entity ent) {
        Vector3f origin = ent.getOrigin();
        Vector3f angles = ent.getAngles();
        if (origin == null) {
            return;
        }
        if (angles == null) {
            angles = Vector3f.NULL;
        }
        Vector3f pos = origin.add(new Vector3f(0.0f, 0.0f, 64.0f));
        Vector3f look = new Vector3f(192.0f, 0.0f, 0.0f).rotate(angles).add(origin);
        pos = look.sub(pos).normalize().scalar(-64.0f).add(pos);
        this.vmfmeta.getCameras().add(new Camera(pos, look));
    }

    public void setNmo(NmoFile nmoData) {
        this.nmo = nmoData;
        for (NmoObjective nmoObjective : nmoData.nodes) {
            try {
                this.vmfmeta.reserveVisgroupId(nmoObjective.id, "Objectives", nmoObjective.name);
            }
            catch (VmfMeta.VisgroupException e) {
                L.error("Error reserving visgroup ids for Nmrih Objectives", (Throwable)e);
            }
        }
        for (NmoAntiObjective nmoAntiObjective : nmoData.antiNodes) {
            try {
                this.vmfmeta.reserveVisgroupId(nmoAntiObjective.id, "Objectives", "anti", nmoAntiObjective.name);
            }
            catch (VmfMeta.VisgroupException e) {
                L.error("Error reserving visgroup ids for Nmrih Objectives", (Throwable)e);
            }
        }
        nmoData.extractions.forEach(extraction -> this.vmfmeta.getUIDBlackList().add(extraction.id));
    }
}

