/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.modules;

import info.ata4.bspsrc.decompiler.BspSourceConfig;
import info.ata4.bspsrc.decompiler.VmfWriter;
import info.ata4.bspsrc.decompiler.modules.BspProtection;
import info.ata4.bspsrc.decompiler.modules.ModuleDecompile;
import info.ata4.bspsrc.decompiler.modules.VmfMeta;
import info.ata4.bspsrc.decompiler.modules.entity.EntitySource;
import info.ata4.bspsrc.decompiler.modules.geom.BrushBounds;
import info.ata4.bspsrc.decompiler.modules.geom.BrushMode;
import info.ata4.bspsrc.decompiler.modules.geom.BrushSideFaceMapper;
import info.ata4.bspsrc.decompiler.modules.geom.BrushSource;
import info.ata4.bspsrc.decompiler.modules.geom.FaceSource;
import info.ata4.bspsrc.decompiler.modules.texture.TextureSource;
import info.ata4.bspsrc.decompiler.util.WindingFactory;
import info.ata4.bspsrc.lib.BspFileReader;
import info.ata4.bspsrc.lib.nmo.NmoFile;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BspDecompiler
extends ModuleDecompile {
    private static final Logger L = LogManager.getLogger();
    private final WindingFactory windingFactory = new WindingFactory();
    private final BrushBounds brushBounds = new BrushBounds(this.windingFactory);
    private final BspSourceConfig config;
    private final BrushSideFaceMapper brushSideFaceMapper;
    private final TextureSource texsrc;
    private final BrushSource brushsrc;
    private final FaceSource facesrc;
    private final EntitySource entsrc;
    private final BspProtection bspprot;
    private final VmfMeta vmfmeta;

    public BspDecompiler(BspFileReader reader, VmfWriter writer, BspSourceConfig config) {
        super(reader, writer);
        this.config = config;
        this.texsrc = new TextureSource(reader);
        this.bspprot = new BspProtection(reader, this.brushBounds, this.texsrc);
        this.vmfmeta = new VmfMeta(reader, writer);
        this.brushSideFaceMapper = new BrushSideFaceMapper(reader, this.windingFactory);
        this.brushsrc = new BrushSource(reader, writer, config, this.texsrc, this.bspprot, this.vmfmeta, this.brushSideFaceMapper, this.windingFactory);
        this.facesrc = new FaceSource(reader, writer, config, this.texsrc, this.vmfmeta, this.windingFactory);
        this.entsrc = new EntitySource(reader, writer, config, this.brushsrc, this.facesrc, this.texsrc, this.bspprot, this.vmfmeta, this.brushSideFaceMapper, this.windingFactory, this.brushBounds);
    }

    public void start() {
        this.texsrc.setFixTextureNames(this.config.fixCubemapTextures);
        this.texsrc.setFixToolTextures(this.config.fixToolTextures);
        if (!this.config.skipProt) {
            this.checkProtection();
        }
        if (this.config.brushMode == BrushMode.BRUSHPLANES) {
            this.brushSideFaceMapper.load();
        }
        this.vmfmeta.appendComment("Decompiled by BSPSource v1.4.4 from " + this.bspFile.getName());
        this.vmfmeta.writeWorldHeader();
        if (this.config.writeWorldBrushes) {
            this.writeBrushes();
        }
        this.vmfmeta.writeWorldFooter();
        if (this.config.isWriteEntities()) {
            this.writeEntities();
        }
        if (this.config.writeVisgroups) {
            this.vmfmeta.writeVisgroups();
        }
        if (this.config.writeCameras) {
            this.vmfmeta.writeCameras();
        }
    }

    private void checkProtection() {
        if (!this.bspprot.check()) {
            return;
        }
        L.warn("{} contains anti-decompiling flags or is obfuscated!", (Object)this.reader.getBspFile().getName());
        L.warn("Detected methods:");
        List<String> methods = this.bspprot.getProtectionMethods();
        for (String method : methods) {
            L.warn(method);
        }
    }

    private void writeBrushes() {
        switch (this.config.brushMode) {
            case BRUSHPLANES: {
                this.brushsrc.writeBrushes();
                break;
            }
            case ORIGFACE: {
                this.facesrc.writeOrigFaces();
                break;
            }
            case ORIGFACE_PLUS: {
                this.facesrc.writeOrigFacesPlus();
                break;
            }
            case SPLITFACE: {
                this.facesrc.writeFaces();
                break;
            }
        }
        if (this.config.brushMode == BrushMode.BRUSHPLANES) {
            this.facesrc.writeDispFaces();
        }
    }

    private void writeEntities() {
        if (this.config.isWriteEntities()) {
            this.entsrc.writeEntities();
        }
        if (this.config.writeBrushEntities && this.config.writeDetails && this.config.brushMode == BrushMode.BRUSHPLANES) {
            this.entsrc.writeDetails();
        }
        if (this.config.writePointEntities) {
            if (this.config.writeOverlays) {
                this.entsrc.writeOverlays();
            }
            if (this.config.writeStaticProps) {
                this.entsrc.writeStaticProps();
            }
            if (this.config.writeCubemaps) {
                this.entsrc.writeCubemaps();
            }
            if (this.config.writeLadders && !BspDecompiler.usesNonObjectBrushLadders(this.bspFile.getAppId())) {
                this.entsrc.writeLadders();
            }
        }
    }

    public void setNmoData(NmoFile nmo) {
        this.entsrc.setNmo(nmo);
    }

    public static boolean usesNonObjectBrushLadders(int appId) {
        return appId == 730;
    }
}

