/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler;

import info.ata4.bspsrc.decompiler.modules.texture.Texture;
import info.ata4.bspsrc.decompiler.modules.texture.TextureAxis;
import info.ata4.bspsrc.lib.entity.Entity;
import info.ata4.bspsrc.lib.entity.KeyValue;
import info.ata4.bspsrc.lib.vector.Vector3f;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VmfWriter
implements Closeable {
    private static final Logger L = LogManager.getLogger();
    private final PrintWriter pw;
    private final Deque<String> section = new ArrayDeque<String>();
    private final DecimalFormat decimalFormat = new DecimalFormat("0.####", new DecimalFormatSymbols(Locale.ENGLISH));

    public VmfWriter(File file) throws FileNotFoundException, UnsupportedEncodingException {
        this.pw = new PrintWriter(file, "US-ASCII");
    }

    public VmfWriter(OutputStream os) {
        this.pw = new PrintWriter(os);
    }

    private void indent() {
        for (int i = 0; i < this.section.size(); ++i) {
            this.pw.print("\t");
        }
    }

    public void start(String name) {
        this.indent();
        this.pw.print(name);
        this.pw.print("\r\n");
        this.indent();
        this.pw.print("{\r\n");
        this.section.addFirst(name);
    }

    public void end(String name) {
        String s = this.section.peekFirst();
        if (s == null) {
            throw new NoSuchElementException("No open sections left");
        }
        if (!s.equals(name)) {
            throw new NoSuchElementException("VMF section end name mismatch. Expected: '%s', got '%s'".formatted(name, s));
        }
        this.section.removeFirst();
        this.indent();
        this.pw.print("}\r\n");
    }

    public void put(String key, Object value) {
        this.indent();
        this.pw.printf("\"%s\" \"%s\"\r\n", key, value);
    }

    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, float value) {
        this.put(key, this.formatFloat(value));
    }

    public void put(String key, double value) {
        this.put(key, this.formatFloat(value));
    }

    public void put(String key, boolean value) {
        this.put(key, value ? "1" : "0");
    }

    public void put(String key, char value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, Vector3f v, int p) {
        this.put(key, this.formatVector3f(v, p));
    }

    public void put(String key, Vector3f v) {
        this.put(key, this.formatVector3f(v, 0));
    }

    public void put(String key, Vector3f v1, Vector3f v2, Vector3f v3) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatVector3f(v1, 1));
        sb.append(' ');
        sb.append(this.formatVector3f(v2, 1));
        sb.append(' ');
        sb.append(this.formatVector3f(v3, 1));
        this.put(key, sb.toString());
    }

    public void put(String key, TextureAxis axis) {
        this.put(key, this.formatTextureAxis(axis));
    }

    public void put(Map<String, String> stringMap) {
        for (String key : stringMap.keySet()) {
            this.put(key, stringMap.get(key));
        }
    }

    public void put(Entity entity) {
        for (Map.Entry<String, String> kv : entity.getEntrySet()) {
            this.put(kv.getKey(), kv.getValue());
        }
    }

    public void put(Texture tex) {
        this.put("material", tex.getTexture());
        this.put("uaxis", tex.getUAxis());
        this.put("vaxis", tex.getVAxis());
        this.put("lightmapscale", tex.getLightmapScale());
    }

    public void put(KeyValue keyValue) {
        this.put(keyValue.getKey(), keyValue.getValue());
    }

    private String formatVector3f(Vector3f v, int p) {
        StringBuilder sb = new StringBuilder();
        if (p == 1) {
            sb.append('(');
        } else if (p == 2) {
            sb.append('[');
        }
        if (!v.isValid()) {
            L.warn("Invalid vector: {}", (Object)v);
            sb.append("0 0 0");
        } else {
            sb.append(this.formatFloat(v.x)).append(' ');
            sb.append(this.formatFloat(v.y)).append(' ');
            sb.append(this.formatFloat(v.z));
        }
        if (p == 1) {
            sb.append(')');
        } else if (p == 2) {
            sb.append(']');
        }
        return sb.toString();
    }

    private String formatTextureAxis(TextureAxis tx) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (!tx.axis.isValid()) {
            L.warn("Invalid vector: {}", (Object)tx.axis);
            sb.append("0 0 0 ");
        } else {
            sb.append(this.formatFloat(tx.axis.x)).append(' ');
            sb.append(this.formatFloat(tx.axis.y)).append(' ');
            sb.append(this.formatFloat(tx.axis.z)).append(' ');
        }
        sb.append(this.formatFloat(tx.shift));
        sb.append("] ");
        sb.append(this.formatFloat(tx.tw));
        return sb.toString();
    }

    private String formatFloat(double f) {
        return this.decimalFormat.format(f);
    }

    @Override
    public void close() {
        this.pw.close();
        if (!this.section.isEmpty()) {
            String stackState = String.join((CharSequence)" -> ", this.section::descendingIterator);
            L.warn("Unclosed VMF chunk: {}", (Object)stackState);
        }
    }
}

