/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler;

import info.ata4.bspsrc.decompiler.BspFileEntry;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import info.ata4.bspsrc.decompiler.BspSourceException;
import info.ata4.bspsrc.decompiler.VmfWriter;
import info.ata4.bspsrc.decompiler.modules.BspDecompiler;
import info.ata4.bspsrc.decompiler.modules.texture.TextureSource;
import info.ata4.bspsrc.lib.BspFile;
import info.ata4.bspsrc.lib.BspFileReader;
import info.ata4.bspsrc.lib.PakFile;
import info.ata4.bspsrc.lib.app.SourceAppDB;
import info.ata4.bspsrc.lib.exceptions.BspException;
import info.ata4.bspsrc.lib.nmo.NmoException;
import info.ata4.bspsrc.lib.nmo.NmoFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BspSource {
    private static final Logger L = LogManager.getLogger();
    public static final String DECOMPILE_TASK_ID_IDENTIFIER = "decompile_id";
    public static final String VERSION = "1.4.4";
    private final BspSourceConfig config;
    private final List<BspFileEntry> entries;
    private final List<UUID> entryUuids;

    public BspSource(BspSourceConfig config, List<BspFileEntry> entries) {
        this.config = Objects.requireNonNull(config);
        this.entries = List.copyOf(entries);
        this.entryUuids = Stream.generate(UUID::randomUUID).limit(entries.size()).toList();
    }

    public void run(Consumer<Signal> signalConsumer) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        if (this.config.debug) {
            this.config.dumpToLog();
        }
        if (this.entries.isEmpty()) {
            return;
        }
        L.info("Starting...");
        LinkedBlockingQueue outputQueue = new LinkedBlockingQueue();
        try (ExecutorService executorService = Executors.newWorkStealingPool();){
            int i = 0;
            while (i < this.entries.size()) {
                int finalI = i++;
                executorService.submit(() -> this.decompile(finalI, outputQueue));
            }
            try {
                int remainingTasks = this.entries.size();
                while (remainingTasks > 0) {
                    Signal signal = (Signal)outputQueue.take();
                    signalConsumer.accept(signal);
                    if (!(signal instanceof Signal.TaskFinished) && !(signal instanceof Signal.TaskFailed)) continue;
                    --remainingTasks;
                }
            }
            catch (InterruptedException e) {
                L.info("Stopping because of interrupt");
                Thread.currentThread().interrupt();
                throw e;
            }
        }
        double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        L.info("Processed %d file(s) in %.4f seconds".formatted(this.entries.size(), duration));
    }

    private void decompile(int index, BlockingQueue<Signal> outputQueue) {
        BspFileEntry entry = this.entries.get(index);
        UUID uuid = this.entryUuids.get(index);
        try (CloseableThreadContext.Instance closeable = CloseableThreadContext.put(DECOMPILE_TASK_ID_IDENTIFIER, uuid.toString());){
            outputQueue.add(new Signal.TaskStarted(index));
            try {
                this.decompile(entry);
                outputQueue.add(new Signal.TaskFinished(index));
            }
            catch (Throwable e) {
                L.error("Error occurred decompiling '%s'".formatted(entry.getBspFile()), e);
                outputQueue.add(new Signal.TaskFailed(index, e));
            }
        }
    }

    private void decompile(BspFileEntry entry) throws BspSourceException, BspException {
        NmoFile nmo;
        BspFileReader reader;
        Path vmfFile;
        Path bspFile;
        block23: {
            bspFile = entry.getBspFile();
            vmfFile = entry.getVmfFile();
            Path nmoFile = entry.getNmoFile();
            Path nmosFile = entry.getNmosFile();
            L.info("Loading {}", (Object)bspFile);
            BspFile bsp = new BspFile();
            bsp.setAppId(this.config.defaultAppId);
            try {
                bsp.load(bspFile);
            }
            catch (NoSuchFileException e) {
                throw new BspSourceException("Could not find bsp file.", e);
            }
            catch (IOException e) {
                throw new BspSourceException("Error loading bsp file.", e);
            }
            if (this.config.loadLumpFiles) {
                bsp.loadLumpFiles();
            }
            Predicate<String> fileFilter = filename -> !this.config.smartUnpack || !PakFile.isVBSPGeneratedFile(filename) && !TextureSource.isPatchedMaterial(filename);
            if (this.config.unpackEmbedded) {
                try {
                    bsp.getPakFile().unpack(entry.getPakDir(), fileFilter);
                }
                catch (IOException e) {
                    throw new BspSourceException("Can't extract embedded files.", e);
                }
            }
            reader = new BspFileReader(bsp);
            reader.loadAll();
            nmo = null;
            if (reader.getBspFile().getAppId() == 224260) {
                if (Files.exists(nmoFile, new LinkOption[0])) {
                    try {
                        nmo = new NmoFile();
                        nmo.load(nmoFile, true);
                        try {
                            nmo.writeAsNmos(nmosFile);
                            break block23;
                        }
                        catch (IOException e) {
                            throw new BspSourceException("Error writing nmos file.", e);
                        }
                    }
                    catch (NmoException | IOException e) {
                        throw new BspSourceException("Error loading nmo file.", e);
                    }
                }
                L.warn("Missing .nmo file! If the bsp is for the objective game mode, its objectives will be missing.");
            }
        }
        if (!this.config.debug) {
            int appId = reader.getBspFile().getAppId();
            String gameName = SourceAppDB.getInstance().getName(appId).orElse(String.valueOf(appId));
            L.info("BSP version: {}", (Object)reader.getBspFile().getVersion());
            L.info("Game: {}", (Object)gameName);
        }
        try (VmfWriter writer = this.getVmfWriter(vmfFile.toFile());){
            BspDecompiler decompiler = new BspDecompiler(reader, writer, this.config);
            if (nmo != null) {
                decompiler.setNmoData(nmo);
            }
            decompiler.start();
            L.info("Finished decompiling {}.", (Object)bspFile);
        }
        catch (IOException e) {
            throw new BspSourceException("Error decompiling bsp.", e);
        }
    }

    private VmfWriter getVmfWriter(File vmfFile) throws IOException {
        if (this.config.nullOutput) {
            return new VmfWriter(OutputStream.nullOutputStream());
        }
        return new VmfWriter(vmfFile);
    }

    public List<UUID> getEntryUuids() {
        return this.entryUuids;
    }

    public static sealed interface Signal {

        public record TaskFailed(int index, Throwable exception) implements Signal
        {
        }

        public record TaskFinished(int index) implements Signal
        {
        }

        public record TaskStarted(int index) implements Signal
        {
        }
    }
}

