/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler;

import info.ata4.bspsrc.common.util.PathUtil;
import java.nio.file.Path;
import java.util.Objects;

public class BspFileEntry {
    private final Path bspFile;
    private Path vmfFile;
    private Path pakfileDir;
    private Path nmoFile;
    private Path nmosFile;

    public BspFileEntry(Path bspFile, Path vmfFile) {
        this.bspFile = Objects.requireNonNull(bspFile);
        this.vmfFile = Objects.requireNonNull(vmfFile);
        this.pakfileDir = BspFileEntry.replaceExtension(vmfFile, "");
        this.nmoFile = BspFileEntry.replaceExtension(bspFile, ".nmo");
        this.nmosFile = BspFileEntry.replaceExtension(vmfFile, ".nmos");
    }

    private static Path replaceExtension(Path path, String newExt) {
        String base = PathUtil.nameWithoutExtension(path).orElse("");
        return path.resolveSibling(base + newExt);
    }

    public Path getBspFile() {
        return this.bspFile;
    }

    public Path getVmfFile() {
        return this.vmfFile;
    }

    public void setVmfFile(Path vmfFile) {
        this.vmfFile = vmfFile;
    }

    public Path getPakDir() {
        return this.pakfileDir;
    }

    public void setPakDir(Path pakfileDir) {
        this.pakfileDir = pakfileDir;
    }

    public Path getNmoFile() {
        return this.nmoFile;
    }

    public Path getNmosFile() {
        return this.nmosFile;
    }

    public void setNmosFile(Path nmosFile) {
        Objects.requireNonNull(nmosFile);
        this.nmosFile = nmosFile;
    }

    public String toString() {
        return this.bspFile.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BspFileEntry other = (BspFileEntry)obj;
        return this.bspFile == other.bspFile || this.bspFile.equals(other.bspFile);
    }

    public int hashCode() {
        return this.bspFile.hashCode();
    }
}

