/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.common.util;

import java.util.EnumSet;
import java.util.Set;

public class EnumConverter {
    private EnumConverter() {
    }

    public static <E extends Enum<E>> int toInteger(Set<E> flags) {
        int mask = 0;
        for (Enum flag : flags) {
            mask |= 1 << flag.ordinal();
        }
        return mask;
    }

    public static <E extends Enum<E>> Set<E> fromInteger(Class<E> elementType, int mask) {
        EnumSet<Enum> flags = EnumSet.noneOf(elementType);
        for (Enum value : (Enum[])elementType.getEnumConstants()) {
            if ((mask & 1 << value.ordinal()) == 0) continue;
            flags.add(value);
        }
        return flags;
    }

    public static <E extends Enum<E>> E fromOrdinal(Class<E> elementType, int index) {
        EnumSet<Enum> modes = EnumSet.allOf(elementType);
        for (Enum mode : modes) {
            if (mode.ordinal() != index) continue;
            return (E)mode;
        }
        throw new IllegalArgumentException();
    }
}

