/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.util.swing.renderer;

import java.awt.Component;
import java.text.StringCharacterIterator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ByteSizeCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Long) {
            Long l = (Long)value;
            value = ByteSizeCellRenderer.humanReadableByteCountSI(l);
        } else if (value instanceof Integer) {
            Integer i = (Integer)value;
            value = ByteSizeCellRenderer.humanReadableByteCountSI(i.intValue());
        }
        JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        c.setHorizontalAlignment(4);
        return c;
    }

    public static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }
}

