/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.util.swing.components;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class URILabel
extends JLabel {
    private static final Logger L = LogManager.getLogger();
    private URI uri;

    public URILabel() {
        this.setCursor(new Cursor(12));
        this.addMouseListener(new URLOpenAdapter());
    }

    public void setURI(String text, URI uri) {
        this.uri = uri;
        super.setText("<html><body><a href=\"" + String.valueOf(uri) + "\">" + text + "</a></body></html>");
    }

    public void setURI(String text, String uriString) {
        try {
            this.setURI(text, new URI(uriString));
        }
        catch (URISyntaxException ex) {
            L.warn("Invalid URI format", (Throwable)ex);
            this.setText(text);
        }
    }

    private class URLOpenAdapter
    extends MouseAdapter {
        private URLOpenAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(URILabel.this.uri);
                }
                catch (IOException ex) {
                    L.warn("Can't browse URI", (Throwable)ex);
                }
            }
        }
    }
}

