/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.util.swing;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.extras.FlatAnimatedLafChange;
import com.jthemedetecor.OsThemeDetector;
import info.ata4.bspsrc.app.util.swing.ui.CustomFlatLabelUI;
import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class GuiUtil {
    public static void debugDisplay(Supplier<Container> containerSupplier) {
        GuiUtil.setupFlatlaf();
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame();
            frame.setContentPane((Container)containerSupplier.get());
            frame.pack();
            frame.setMinimumSize(frame.getSize());
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
        });
    }

    public static void setupFlatlaf() {
        System.setProperty("flatlaf.animation", "true");
        Consumer<Boolean> changeTheme = isDark -> SwingUtilities.invokeLater(() -> {
            FlatAnimatedLafChange.showSnapshot();
            if (isDark.booleanValue()) {
                FlatDarkLaf.setup();
            } else {
                FlatLightLaf.setup();
            }
            UIManager.put("LabelUI", CustomFlatLabelUI.class.getName());
            FlatLaf.updateUI();
            FlatAnimatedLafChange.hideSnapshotWithAnimation();
        });
        OsThemeDetector detector = OsThemeDetector.getDetector();
        detector.registerListener(changeTheme);
        changeTheme.accept(detector.isDark());
    }

    public static void setColumnWidth(JTable table, int columnIndex, Object value, boolean alsoSetMax, boolean alsoSetMin) {
        RowSorter<? extends TableModel> rowSorter;
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer == null) {
            JTableHeader tableHeader = table.getTableHeader();
            headerRenderer = tableHeader == null ? null : tableHeader.getDefaultRenderer();
        }
        int cellWidth = 0;
        if (headerRenderer != null) {
            Component headerCell = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, columnIndex);
            cellWidth = headerCell.getPreferredSize().width;
        }
        if ((rowSorter = table.getRowSorter()) != null) {
            List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
            for (SortOrder sortOrder : SortOrder.values()) {
                rowSorter.setSortKeys(List.of(new RowSorter.SortKey(columnIndex, sortOrder)));
                Component cell = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, columnIndex);
                cellWidth = Math.max(cellWidth, cell.getPreferredSize().width);
            }
            rowSorter.setSortKeys(sortKeys);
        }
        Component cell = table.getCellRenderer(-1, columnIndex).getTableCellRendererComponent(table, value, false, false, -1, columnIndex);
        int width = Math.max(cell.getPreferredSize().width, cellWidth);
        column.setPreferredWidth(width);
        if (alsoSetMin) {
            column.setMinWidth(width);
        }
        if (alsoSetMax) {
            column.setMaxWidth(width);
        }
    }

    public static Stream<Component> getComponentsRecursive(Component root) {
        Stream<Component> components = Stream.of(root);
        if (root instanceof Container) {
            Container container = (Container)root;
            Stream subComponents = Arrays.stream(container.getComponents()).flatMap(GuiUtil::getComponentsRecursive);
            components = Stream.concat(components, subComponents);
        }
        return components;
    }
}

