/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.util.swing;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.function.Consumer;

public class GridBagConstraintsBuilder {
    private final GridBagConstraints constraints;

    public GridBagConstraintsBuilder() {
        this(new GridBagConstraints());
    }

    private GridBagConstraintsBuilder(GridBagConstraints constraints) {
        this.constraints = constraints;
    }

    public GridBagConstraintsBuilder position(int x, int y) {
        return this.inferBuilder(constraints -> {
            constraints.gridx = x;
            constraints.gridy = y;
        });
    }

    public GridBagConstraintsBuilder anchor(Anchor anchor) {
        return this.inferBuilder(constraints -> {
            constraints.anchor = anchor.id;
        });
    }

    public GridBagConstraintsBuilder width(int width) {
        return this.inferBuilder(constraints -> {
            constraints.gridwidth = width;
        });
    }

    public GridBagConstraintsBuilder height(int height) {
        return this.inferBuilder(constraints -> {
            constraints.gridheight = height;
        });
    }

    public GridBagConstraintsBuilder weightX(int weight) {
        return this.inferBuilder(constraints -> {
            constraints.weightx = weight;
        });
    }

    public GridBagConstraintsBuilder weightY(int weight) {
        return this.inferBuilder(constraints -> {
            constraints.weighty = weight;
        });
    }

    public GridBagConstraintsBuilder fill(Fill fill) {
        return this.inferBuilder(constraints -> {
            constraints.fill = fill.id;
        });
    }

    public GridBagConstraintsBuilder insets(Insets insets) {
        return this.inferBuilder(constraints -> {
            constraints.insets = insets;
        });
    }

    public GridBagConstraints build() {
        return this.constraints;
    }

    private GridBagConstraintsBuilder inferBuilder(Consumer<GridBagConstraints> action) {
        GridBagConstraints constraints = (GridBagConstraints)this.constraints.clone();
        action.accept(constraints);
        return new GridBagConstraintsBuilder(constraints);
    }

    public static enum Anchor {
        CENTER(10),
        NORTH(11),
        NORTHEAST(12),
        EAST(13),
        SOUTHEAST(14),
        SOUTH(15),
        SOUTHWEST(16),
        WEST(17),
        NORTHWEST(18),
        PAGE_START(19),
        PAGE_END(20),
        LINE_START(21),
        LINE_END(22),
        FIRST_LINE_START(23),
        FIRST_LINE_END(24),
        LAST_LINE_START(25),
        LAST_LINE_END(26),
        BASELINE(256),
        BASELINE_LEADING(512),
        BASELINE_TRAILING(768),
        ABOVE_BASELINE(1024),
        ABOVE_BASELINE_LEADING(1280),
        ABOVE_BASELINE_TRAILING(1536),
        BELOW_BASELINE(1792),
        BELOW_BASELINE_LEADING(2048),
        BELOW_BASELINE_TRAILING(2304);

        public final int id;

        private Anchor(int id) {
            this.id = id;
        }
    }

    public static enum Fill {
        NONE(0),
        HORIZONTAL(2),
        VERTICAL(3),
        BOTH(1);

        public final int id;

        private Fill(int id) {
            this.id = id;
        }
    }
}

