/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.util.log.plugins;

import java.io.Serializable;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Document", category="Core", elementType="appender")
public class DocumentAppender
extends AbstractAppender {
    private final Document document;

    public DocumentAppender(String name, Filter filter, Layout<String> layout, boolean ignoreExceptions, Property[] properties, Document document) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.document = Objects.requireNonNull(document);
    }

    @Override
    public void append(LogEvent event) {
        String str = (String)((StringLayout)this.getLayout()).toSerializable(event);
        if (str.isBlank()) {
            return;
        }
        try {
            this.document.insertString(this.document.getLength(), str, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @PluginFactory
    public static DocumentAppender createAppender(String name, Filter filter, Layout<String> layout, boolean ignoreExceptions, Document document) {
        if (name == null) {
            LOGGER.error("No name provided for DocumentAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (document == null) {
            LOGGER.error("No document provided for DocumentAppender");
        }
        return new DocumentAppender(name, filter, layout, ignoreExceptions, null, document);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<DocumentAppender> {
        private Document document;

        @Override
        public DocumentAppender build() {
            Layout<Serializable> layout = this.getOrCreateLayout();
            if (!(layout instanceof StringLayout)) {
                LOGGER.error("Layout must be a StringLayout");
                return null;
            }
            StringLayout stringLayout = (StringLayout)layout;
            if (this.document == null) {
                LOGGER.error("No document specified");
                return null;
            }
            return new DocumentAppender(this.getName(), this.getFilter(), stringLayout, this.isIgnoreExceptions(), this.getPropertyArray(), this.document);
        }

        public B setDocument(Document document) {
            this.document = document;
            return (B)((Builder)this.asBuilder());
        }
    }
}

