/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.unprotect;

import info.ata4.bspsrc.app.unprotect.IceKey;
import info.ata4.bspsrc.lib.BspFile;
import info.ata4.bspsrc.lib.exceptions.BspException;
import info.ata4.bspsrc.lib.lump.Lump;
import info.ata4.bspsrc.lib.lump.LumpFile;
import info.ata4.bspsrc.lib.lump.LumpType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class BspUnprotect {
    public static final String VERSION = "1.0";
    public static final String BSPPROTECT_FILE = "entities.dat";
    public static final String BSPPROTECT_KEY = "EhZT36ErlQlZpLm7";
    private BspFile bspFile;
    private byte[] key;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("BspUnprotect 1.0");
            System.out.println("Usage: bspunprotect.jar <BSP file> [key]");
            System.exit(0);
        }
        Path file = Paths.get(args[0], new String[0]);
        byte[] key = args.length >= 2 ? args[1].getBytes() : BSPPROTECT_KEY.getBytes();
        try {
            BspUnprotect unprot = new BspUnprotect();
            unprot.setKey(key);
            unprot.decrypt(file);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void setKey(byte[] key) {
        if (key.length % 8 != 0) {
            throw new IllegalArgumentException("Invalid key length, must be multiple of 8");
        }
        this.key = key;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void decrypt(Path file) {
        System.out.println("Loading BSP file " + String.valueOf(file.getFileName()));
        try {
            this.bspFile = new BspFile();
            this.bspFile.load(file);
        }
        catch (BspException | IOException ex) {
            throw new RuntimeException("Couldn't load BSP file", ex);
        }
        System.out.println("Reading pakfile lump");
        byte[] encEnt = this.readEncryptedEntities();
        if (encEnt == null) {
            throw new RuntimeException("This map wasn't protected by BSPProtect");
        }
        System.out.println("Restoring entities");
        Lump entLump = this.bspFile.getLump(LumpType.LUMP_ENTITIES);
        int capacity = encEnt.length;
        if (entLump.getLength() > 0) {
            capacity += entLump.getLength();
        }
        ByteBuffer entBuf = ByteBuffer.allocateDirect(capacity);
        entBuf.order(this.bspFile.getByteOrder());
        if (entLump.getLength() > 0) {
            ByteBuffer entBufOld = entLump.getBuffer();
            entBufOld.limit(entBufOld.limit() - 1);
            entBuf.put(entBufOld);
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(encEnt);
            IceKey ice = new IceKey(this.key.length / 8 - 1);
            ice.set(this.key);
            int blockSize = ice.blockSize();
            byte[] cipher = new byte[blockSize];
            byte[] plain = new byte[blockSize];
            int read = 0;
            while (read != -1) {
                ice.decrypt(cipher, plain);
                entBuf.put(read == blockSize ? plain : cipher, 0, read);
                read = is.read(cipher);
            }
            entBuf.put((byte)0);
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldn't decrypt entity data", ex);
        }
        entBuf.flip();
        System.out.println("Writing lump file");
        try {
            Lump entLumpNew = new Lump(LumpType.LUMP_ENTITIES);
            entLumpNew.setBuffer(entBuf);
            LumpFile lump = new LumpFile(this.bspFile);
            lump.setLump(entLumpNew);
            lump.save(this.bspFile.getNextLumpFile());
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldn't write decrypted entity lump file", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readEncryptedEntities() {
        try (ZipFile zip = this.bspFile.getPakFile().getZipFile();){
            Iterator<ZipArchiveEntry> iterator = zip.getEntries(BSPPROTECT_FILE).iterator();
            if (!iterator.hasNext()) return null;
            byte[] byArray = zip.getInputStream(iterator.next()).readAllBytes();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldn't read pakfile", ex);
        }
    }
}

