/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.models;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FilesModel {
    private final List<Path> bspPaths = new ArrayList<Path>();
    private final Set<Listener> onChangeListeners = new HashSet<Listener>();

    public List<Path> getBspPaths() {
        return Collections.unmodifiableList(this.bspPaths);
    }

    public void addListener(Listener listener) {
        this.onChangeListeners.add(listener);
    }

    public void addEntries(Collection<Path> bspPaths) {
        if (bspPaths.isEmpty()) {
            return;
        }
        int minIndex = this.bspPaths.size();
        this.bspPaths.addAll(bspPaths);
        int maxIndex = this.bspPaths.size() - 1;
        this.onChangeListeners.forEach(listener -> listener.added(minIndex, maxIndex));
    }

    public void removeEntries(int[] selectedIndices) {
        Arrays.stream(selectedIndices).boxed().sorted(Comparator.reverseOrder()).forEachOrdered(i -> {
            this.bspPaths.remove((int)i);
            this.onChangeListeners.forEach(listener -> listener.removed((int)i, (int)i));
        });
    }

    public void removeAllEntries() {
        int maxIndex = this.bspPaths.size() - 1;
        this.bspPaths.clear();
        this.onChangeListeners.forEach(listener -> listener.removed(0, maxIndex));
    }

    public static interface Listener {
        public void added(int var1, int var2);

        public void removed(int var1, int var2);
    }
}

