/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.models;

import info.ata4.bspsrc.app.src.gui.data.ErrorNotification;
import info.ata4.bspsrc.app.src.gui.data.Task;
import info.ata4.bspsrc.app.util.ErrorMessageUtil;
import info.ata4.bspsrc.app.util.log.Log4jUtil;
import info.ata4.bspsrc.decompiler.BspFileEntry;
import info.ata4.bspsrc.decompiler.BspSource;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingWorker;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DecompileTaskModel {
    private final DecompileWorker worker;
    private final List<Consumer<State>> stateListeners = new ArrayList<Consumer<State>>();
    private final List<Consumer<Integer>> taskChangeListeners = new ArrayList<Consumer<Integer>>();
    private final List<Consumer<ErrorNotification>> notificationsListeners = new ArrayList<Consumer<ErrorNotification>>();
    private State state = new State.Running();
    private final List<Task> tasks;
    private final List<Document> taskLogs;

    public DecompileTaskModel(BspSourceConfig config, List<BspFileEntry> entries) {
        this.worker = new DecompileWorker(config, entries);
        this.tasks = entries.stream().map(bspFileEntry -> new Task(Task.State.PENDING, bspFileEntry.getBspFile())).collect(Collectors.toCollection(ArrayList::new));
        this.taskLogs = Stream.generate(PlainDocument::new).limit(this.tasks.size()).collect(Collectors.toList());
        this.worker.execute();
    }

    public void addStateListener(Consumer<State> listener) {
        this.stateListeners.add(listener);
    }

    public void addTaskUpdateListener(Consumer<Integer> listener) {
        this.taskChangeListeners.add(listener);
    }

    public void addNotificationListener(Consumer<ErrorNotification> listener) {
        this.notificationsListeners.add(listener);
    }

    public List<Task> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    private void updateTask(int index, Function<Task, Task> function) {
        Task newTask = function.apply(this.tasks.get(index));
        this.tasks.set(index, newTask);
        this.taskChangeListeners.forEach(consumer -> consumer.accept(index));
    }

    public Document getTaskLog(int index) {
        return this.taskLogs.get(index);
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = Objects.requireNonNull(state);
        this.stateListeners.forEach(consumer -> consumer.accept(state));
    }

    public void close() {
        this.worker.cancel(true);
    }

    public static sealed interface State {

        public record Finished(Throwable t) implements State
        {
        }

        public record Running() implements State
        {
        }
    }

    private class DecompileWorker
    extends SwingWorker<Void, BspSource.Signal> {
        private final BspSourceConfig config;
        private final List<BspFileEntry> entries;

        private DecompileWorker(BspSourceConfig config, List<BspFileEntry> entries) {
            this.config = Objects.requireNonNull(config);
            this.entries = List.copyOf(entries);
        }

        @Override
        protected Void doInBackground() throws InterruptedException {
            BspSource bspSource = new BspSource(this.config, this.entries);
            try (Log4jUtil.CloseableScope scope0 = Log4jUtil.configureDecompilationLogFileAppender(bspSource.getEntryUuids(), this.entries);
                 Log4jUtil.CloseableScope scope1 = Log4jUtil.configureDecompilationDocumentAppenders(bspSource.getEntryUuids(), DecompileTaskModel.this.taskLogs);){
                bspSource.run(xva$0 -> this.publish(xva$0));
            }
            return null;
        }

        @Override
        protected void process(List<BspSource.Signal> signals) {
            for (BspSource.Signal signal : signals) {
                Task.State state;
                int taskIndex;
                if (signal instanceof BspSource.Signal.TaskStarted) {
                    BspSource.Signal.TaskStarted taskSig = (BspSource.Signal.TaskStarted)signal;
                    taskIndex = taskSig.index();
                    state = Task.State.RUNNING;
                } else if (signal instanceof BspSource.Signal.TaskFinished) {
                    BspSource.Signal.TaskFinished taskSig = (BspSource.Signal.TaskFinished)signal;
                    taskIndex = taskSig.index();
                    state = Task.State.FINISHED;
                } else if (signal instanceof BspSource.Signal.TaskFailed) {
                    BspSource.Signal.TaskFailed taskSig = (BspSource.Signal.TaskFailed)signal;
                    taskIndex = taskSig.index();
                    state = Task.State.FAILED;
                } else {
                    throw new RuntimeException("Not reachable");
                }
                DecompileTaskModel.this.updateTask(taskIndex, task -> new Task(state, task.bspFile()));
                if (!(signal instanceof BspSource.Signal.TaskFailed)) continue;
                BspSource.Signal.TaskFailed failed = (BspSource.Signal.TaskFailed)signal;
                ErrorNotification notification = new ErrorNotification(ErrorMessageUtil.decompileExceptionToMessage(failed.exception()), failed.index());
                DecompileTaskModel.this.notificationsListeners.forEach(consumer -> consumer.accept(notification));
            }
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            Throwable failureCause = null;
            try {
                this.get();
            }
            catch (InterruptedException e) {
                failureCause = e;
            }
            catch (ExecutionException e) {
                failureCause = e.getCause();
            }
            DecompileTaskModel.this.setState(new State.Finished(failureCause));
        }
    }
}

