/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.components.main;

import info.ata4.bspsrc.app.src.ObservableBspSourceConfig;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import info.ata4.bspsrc.decompiler.modules.geom.BrushMode;
import java.awt.Component;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;

public class WorldPanel
extends JPanel {
    private final ObservableBspSourceConfig config;
    private final JCheckBox chkEnable = new JCheckBox("Enable"){
        {
            this.addActionListener(e -> WorldPanel.this.config.updateConfig(c -> {
                c.writeWorldBrushes = this.isSelected();
            }));
        }
    };
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JRadioButton rdBrushes = new JRadioButton("Brushes and planes"){
        {
            WorldPanel.this.buttonGroup.add(this);
            this.setToolTipText("Create brushes that closely resemble those\nbrushes from which the map was originally created from.");
            this.addActionListener(e -> WorldPanel.this.config.updateConfig(c -> {
                if (this.isSelected()) {
                    c.brushMode = BrushMode.BRUSHPLANES;
                }
            }));
        }
    };
    private final JRadioButton rdOrig = new JRadioButton("Original faces only"){
        {
            WorldPanel.this.buttonGroup.add(this);
            this.setToolTipText("<html>Create flat brushes from the culled<br>\nbrush sides of the original brushes.<br>\n<b>Note:</b> some sides may be missing.</html>");
            this.addActionListener(e -> WorldPanel.this.config.updateConfig(c -> {
                if (this.isSelected()) {
                    c.brushMode = BrushMode.ORIGFACE;
                }
            }));
        }
    };
    private final JRadioButton rdOrigAndSplit = new JRadioButton("Original/split faces"){
        {
            WorldPanel.this.buttonGroup.add(this);
            this.setToolTipText("Create flat brushes from the culled\nbrush sides of the original brushes.\nWhen a side doesn't exist, the split face\nis created instead.");
            this.addActionListener(e -> WorldPanel.this.config.updateConfig(c -> {
                if (this.isSelected()) {
                    c.brushMode = BrushMode.ORIGFACE_PLUS;
                }
            }));
        }
    };
    private final JRadioButton rdSplit = new JRadioButton("Split faces only"){
        {
            WorldPanel.this.buttonGroup.add(this);
            this.setToolTipText("Create flat brushes from the split faces\nthe engine is using for rendering.");
            this.addActionListener(e -> WorldPanel.this.config.updateConfig(c -> {
                if (this.isSelected()) {
                    c.brushMode = BrushMode.SPLITFACE;
                }
            }));
        }
    };
    private final JPanel pnlMode = new JPanel(new MigLayout()){
        {
            this.setBorder(BorderFactory.createTitledBorder("Mode"));
            this.add((Component)WorldPanel.this.rdBrushes, "wrap");
            this.add((Component)WorldPanel.this.rdOrig, "wrap");
            this.add((Component)WorldPanel.this.rdOrigAndSplit, "wrap");
            this.add((Component)WorldPanel.this.rdSplit, "wrap");
        }
    };
    private final JCheckBox chkWriteDisplacements = new JCheckBox("Write displacements"){
        {
            this.addActionListener(e -> WorldPanel.this.config.updateConfig(c -> {
                c.writeDisp = this.isSelected();
            }));
        }
    };

    public WorldPanel(ObservableBspSourceConfig config) {
        this.config = Objects.requireNonNull(config);
        config.addListener(this::update);
        this.update();
        this.setLayout(new MigLayout("", "[]u[]", ""));
        this.add((Component)this.chkEnable, "wrap");
        this.add(this.pnlMode);
        this.add(this.chkWriteDisplacements);
    }

    private void update() {
        boolean enabled = this.config.get(c -> c.writeWorldBrushes);
        this.chkEnable.setSelected(enabled);
        GuiUtil.getComponentsRecursive(this.pnlMode).forEach(c -> c.setEnabled(enabled));
        this.chkWriteDisplacements.setEnabled(enabled);
        JRadioButton radio = switch (this.config.get(c -> c.brushMode)) {
            default -> throw new IncompatibleClassChangeError();
            case BrushMode.BRUSHPLANES -> this.rdBrushes;
            case BrushMode.ORIGFACE -> this.rdOrig;
            case BrushMode.ORIGFACE_PLUS -> this.rdOrigAndSplit;
            case BrushMode.SPLITFACE -> this.rdSplit;
        };
        radio.setSelected(true);
        this.chkWriteDisplacements.setSelected(this.config.get(c -> c.writeDisp));
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new WorldPanel(new ObservableBspSourceConfig(new BspSourceConfig())));
    }
}

