/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.components.main;

import info.ata4.bspsrc.app.src.gui.models.FilesModel;
import info.ata4.bspsrc.app.util.swing.FileExtensionFilter;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesPanel
extends JPanel {
    private static final Logger L = LogManager.getLogger();
    private final FilesModel model;
    private final JFileChooser bspFileChooser = new JFileChooser(){
        {
            this.setMultiSelectionEnabled(true);
            this.setFileFilter(new FileExtensionFilter("Source engine map file", "bsp"));
        }
    };
    private final JList<Path> lstFiles = new JList();
    private final JScrollPane scrlTable = new JScrollPane(this.lstFiles, 20, 30);
    private final JButton btnAdd = new JButton("Add"){
        {
            this.addActionListener(e -> FilesPanel.this.model.addEntries(FilesPanel.this.chooseBsps()));
        }
    };
    private final JButton btnRemove = new JButton("Remove"){
        {
            this.addActionListener(e -> FilesPanel.this.model.removeEntries(FilesPanel.this.lstFiles.getSelectedIndices()));
        }
    };
    private final JButton btnRemoveAll = new JButton("Remove all"){
        {
            this.addActionListener(e -> FilesPanel.this.model.removeAllEntries());
        }
    };

    public FilesPanel(FilesModel model) {
        this.model = Objects.requireNonNull(model);
        this.initLstFiles();
        this.initTransferHandler();
        this.setLayout(new MigLayout("", "[grow][]", "[][][][grow][]"));
        this.add((Component)this.scrlTable, "grow, spany 4");
        this.add((Component)this.btnAdd, "growx, wrap");
        this.add((Component)this.btnRemove, "growx, wrap");
        this.add((Component)this.btnRemoveAll, "growx, wrap");
        this.add((Component)new JLabel("Tip: drag and drop files/folders on the box above"), "newline");
    }

    private void initLstFiles() {
        this.lstFiles.setModel((ListModel<Path>)new AbstractListModel<Path>(){
            {
                FilesPanel.this.model.addListener(new FilesModel.Listener(){

                    @Override
                    public void added(int minIndex, int maxIndex) {
                        this.fireIntervalAdded(this, minIndex, maxIndex);
                    }

                    @Override
                    public void removed(int minIndex, int maxIndex) {
                        this.fireIntervalRemoved(this, minIndex, maxIndex);
                    }
                });
            }

            @Override
            public int getSize() {
                return FilesPanel.this.model.getBspPaths().size();
            }

            @Override
            public Path getElementAt(int index) {
                return FilesPanel.this.model.getBspPaths().get(index);
            }
        });
    }

    private void initTransferHandler() {
        this.scrlTable.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                boolean canImport = Arrays.stream(support.getDataFlavors()).anyMatch(DataFlavor::isFlavorJavaFileListType);
                if (canImport) {
                    support.setDropAction(2);
                }
                return canImport;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return false;
                }
                try {
                    List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    ArrayList<Path> bspPaths = new ArrayList<Path>();
                    for (File file : files) {
                        Path path = file.toPath();
                        PathMatcher bspMatcher = path.getFileSystem().getPathMatcher("glob:**.bsp");
                        try (Stream<Path> subFilesStream = Files.walk(path, new FileVisitOption[0]);){
                            subFilesStream.skip(1L).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(bspMatcher::matches).forEachOrdered(bspPaths::add);
                        }
                        if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                        bspPaths.add(path);
                    }
                    if (bspPaths.isEmpty()) {
                        JOptionPane.showMessageDialog(FilesPanel.this, "No .bsp files found", null, 2);
                    }
                    FilesPanel.this.model.addEntries(bspPaths);
                    return true;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    L.warn("Error in drag and drop", (Throwable)e);
                    return false;
                }
            }
        });
        try {
            this.scrlTable.getDropTarget().addDropTargetListener(new DropTargetListener(){
                private Border originalBorder;

                @Override
                public void dragEnter(DropTargetDragEvent dtde) {
                    this.originalBorder = FilesPanel.this.scrlTable.getBorder();
                    Color borderColor = UIManager.getColor("Component.focusedBorderColor");
                    CompoundBorder border = BorderFactory.createCompoundBorder(this.originalBorder, BorderFactory.createMatteBorder(2, 2, 2, 2, borderColor));
                    FilesPanel.this.scrlTable.setBorder(border);
                }

                @Override
                public void dragOver(DropTargetDragEvent dtde) {
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent dtde) {
                }

                @Override
                public void dragExit(DropTargetEvent dte) {
                    FilesPanel.this.scrlTable.setBorder(this.originalBorder);
                }

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    FilesPanel.this.scrlTable.setBorder(this.originalBorder);
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<Path> chooseBsps() {
        int result = this.bspFileChooser.showOpenDialog(this);
        if (result != 0) {
            return Set.of();
        }
        return Arrays.stream(this.bspFileChooser.getSelectedFiles()).map(File::toPath).collect(Collectors.toSet());
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new FilesPanel(new FilesModel()));
    }
}

