/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.components.main;

import info.ata4.bspsrc.app.src.ObservableBspSourceConfig;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.decompiler.BspSourceConfig;
import java.awt.Component;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class EntitiesPanel
extends JPanel {
    private final ObservableBspSourceConfig config;
    private final JCheckBox chkEnable = new JCheckBox("Enable"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> c.setWriteEntities(this.isSelected())));
        }
    };
    private final JCheckBox chkDetail = new JCheckBox("Restore func_detail"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> {
                c.writeDetails = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkAreaportal = new JCheckBox("Restore func_areaportal/_window"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> {
                c.writeAreaportals = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkOccluder = new JCheckBox("Restore func_occluder"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> {
                c.writeOccluders = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkLadder = new JCheckBox("Restore func_ladder"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> {
                c.writeLadders = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkFixRotation = new JCheckBox("Fix rotation of instances"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> {
                c.fixEntityRot = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkStaticProp = new JCheckBox("prop_static"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> {
                c.writeStaticProps = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkCubemap = new JCheckBox("info_cubemap"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> {
                c.writeCubemaps = this.isSelected();
            }));
        }
    };
    private final JCheckBox chkOverlay = new JCheckBox("info_overlay"){
        {
            this.addActionListener(e -> EntitiesPanel.this.config.updateConfig(c -> {
                c.writeOverlays = this.isSelected();
            }));
        }
    };
    private final JPanel pnlPointEnts = new JPanel(new MigLayout()){
        {
            this.setBorder(BorderFactory.createTitledBorder("Point entities"));
            this.add((Component)EntitiesPanel.this.chkStaticProp, "wrap");
            this.add((Component)EntitiesPanel.this.chkCubemap, "wrap");
            this.add((Component)EntitiesPanel.this.chkOverlay, "wrap");
        }
    };
    private final JPanel pnlBrushEnts = new JPanel(new MigLayout()){
        {
            this.setBorder(BorderFactory.createTitledBorder("Brush entities"));
            this.add((Component)EntitiesPanel.this.chkDetail, "wrap");
            this.add((Component)EntitiesPanel.this.chkAreaportal, "wrap");
            this.add((Component)EntitiesPanel.this.chkOccluder, "wrap");
            this.add((Component)EntitiesPanel.this.chkLadder, "wrap");
            this.add((Component)EntitiesPanel.this.chkFixRotation, "wrap");
        }
    };

    public EntitiesPanel(ObservableBspSourceConfig config) {
        this.config = Objects.requireNonNull(config);
        config.addListener(this::update);
        this.update();
        this.setLayout(new MigLayout());
        this.add((Component)this.chkEnable, "wrap");
        this.add((Component)this.pnlPointEnts, "growy");
        this.add((Component)this.pnlBrushEnts, "growy");
    }

    private void update() {
        boolean enabled = this.config.get(c -> c.isWriteEntities());
        this.chkEnable.setSelected(enabled);
        GuiUtil.getComponentsRecursive(this.pnlPointEnts).forEach(c -> c.setEnabled(enabled));
        GuiUtil.getComponentsRecursive(this.pnlBrushEnts).forEach(c -> c.setEnabled(enabled));
        this.chkDetail.setSelected(this.config.get(c -> c.writeDetails));
        this.chkAreaportal.setSelected(this.config.get(c -> c.writeAreaportals));
        this.chkOccluder.setSelected(this.config.get(c -> c.writeOccluders));
        this.chkLadder.setSelected(this.config.get(c -> c.writeLadders));
        this.chkFixRotation.setSelected(this.config.get(c -> c.fixEntityRot));
        this.chkStaticProp.setSelected(this.config.get(c -> c.writeStaticProps));
        this.chkCubemap.setSelected(this.config.get(c -> c.writeCubemaps));
        this.chkOverlay.setSelected(this.config.get(c -> c.writeOverlays));
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new EntitiesPanel(new ObservableBspSourceConfig(new BspSourceConfig())));
    }
}

