/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.src.gui.components.main;

import info.ata4.bspsrc.app.src.gui.components.main.EntitiesPanel;
import info.ata4.bspsrc.app.src.gui.components.main.EntityMappingPanel;
import info.ata4.bspsrc.app.src.gui.components.main.FilesPanel;
import info.ata4.bspsrc.app.src.gui.components.main.OtherPanel;
import info.ata4.bspsrc.app.src.gui.components.main.TexturesPanel;
import info.ata4.bspsrc.app.src.gui.components.main.WorldPanel;
import info.ata4.bspsrc.app.src.gui.components.task.DecompileTaskDialog;
import info.ata4.bspsrc.app.src.gui.models.BspSourceModel;
import info.ata4.bspsrc.app.src.gui.models.DecompileTaskModel;
import info.ata4.bspsrc.app.src.gui.models.FilesModel;
import info.ata4.bspsrc.app.util.BspPathUtil;
import info.ata4.bspsrc.app.util.log.Log4jUtil;
import info.ata4.bspsrc.app.util.log.plugins.DialogAppender;
import info.ata4.bspsrc.app.util.log.plugins.IsDecompileTaskFilter;
import info.ata4.bspsrc.app.util.swing.FileExtensionFilter;
import info.ata4.bspsrc.common.util.Collectors;
import info.ata4.bspsrc.decompiler.BspFileEntry;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.core.Filter;

public class BspSourceFrame
extends JFrame {
    private final BspSourceModel model;
    private final FilesModel filesModel = new FilesModel();
    private final JFileChooser vmfFileChooser = new JFileChooser(){
        {
            this.setFileFilter(new FileExtensionFilter("Hammer map file", "vmf"));
        }

        @Override
        public void approveSelection() {
            File file = this.getSelectedFile();
            if (file != null && file.exists() && !this.askOverwrite(file)) {
                return;
            }
            super.approveSelection();
        }

        private boolean askOverwrite(File file) {
            String title = "Overwriting " + file.getPath();
            String message = "File %s already exists.\nDo you like to replace it?".formatted(file.getName());
            int choice = JOptionPane.showConfirmDialog(this, message, title, 0, 2);
            return choice == 0;
        }
    };
    private final JFileChooser vmfDirFileChooser = new JFileChooser(){
        {
            this.setFileSelectionMode(1);
        }
    };
    public final JTabbedPane tbpMain = new JTabbedPane();
    public final FilesPanel filesPanel;
    public final WorldPanel worldPanel;
    public final EntitiesPanel entitiesPanel;
    public final EntityMappingPanel entityMappingPanel;
    public final TexturesPanel texturesPanel;
    public final OtherPanel otherPanel;
    private final JButton btnDefaults = new JButton("Defaults"){
        {
            this.setToolTipText("Resets all configurations to their defaults.");
            this.addActionListener(e -> BspSourceFrame.this.model.setDefaults());
        }
    };
    private final JButton btnDecompile = new JButton("Decompile"){
        {
            this.setFont(this.getFont().deriveFont(1));
            this.addActionListener(e -> BspSourceFrame.this.decompile());
        }
    };

    private void decompile() {
        List<BspFileEntry> entries;
        List<Path> bspPaths = this.filesModel.getBspPaths();
        if (bspPaths.isEmpty()) {
            return;
        }
        if (bspPaths.size() == 1) {
            Path bspPath2 = bspPaths.get(0);
            this.vmfFileChooser.setSelectedFile(BspPathUtil.defaultVmfPath(bspPath2, null).toFile());
            Path vmfPath = this.showSaveDialog(this.vmfFileChooser);
            if (vmfPath == null) {
                return;
            }
            entries = List.of(new BspFileEntry(bspPath2, vmfPath));
        } else {
            Path commonParent = (Path)bspPaths.stream().map(Path::getParent).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.mode()).orElseThrow();
            this.vmfDirFileChooser.setCurrentDirectory(commonParent.toFile());
            Path dirPath = this.showSaveDialog(this.vmfDirFileChooser);
            if (dirPath == null) {
                return;
            }
            entries = bspPaths.stream().map(bspPath -> new BspFileEntry((Path)bspPath, BspPathUtil.defaultVmfPath(bspPath, dirPath))).toList();
        }
        this.model.decompile(entries);
    }

    public BspSourceFrame(BspSourceModel model) {
        this.model = Objects.requireNonNull(model);
        model.addOnDecompileTask(this::onDecompileTask);
        this.initErrorDialog();
        this.filesModel.addListener(new FilesModel.Listener(){

            @Override
            public void added(int minIndex, int maxIndex) {
                BspSourceFrame.this.updateDecompileButton();
            }

            @Override
            public void removed(int minIndex, int maxIndex) {
                BspSourceFrame.this.updateDecompileButton();
            }
        });
        this.updateDecompileButton();
        this.filesPanel = new FilesPanel(this.filesModel);
        this.worldPanel = new WorldPanel(model.getConfig());
        this.entitiesPanel = new EntitiesPanel(model.getConfig());
        this.entityMappingPanel = new EntityMappingPanel(model.getConfig());
        this.texturesPanel = new TexturesPanel(model.getConfig());
        this.otherPanel = new OtherPanel(model.getConfig());
        this.tbpMain.setTabLayoutPolicy(1);
        this.tbpMain.addTab("Files", this.filesPanel);
        this.tbpMain.addTab("World", this.worldPanel);
        this.tbpMain.addTab("Entities", this.entitiesPanel);
        this.tbpMain.addTab("Entity mapping", this.entityMappingPanel);
        this.tbpMain.addTab("Textures", this.texturesPanel);
        this.tbpMain.addTab("Other", this.otherPanel);
        JPanel pnlBottom = new JPanel(new MigLayout("insets 0", "[]push[]", ""));
        pnlBottom.add(this.btnDefaults);
        pnlBottom.add(this.btnDecompile);
        JPanel panel = new JPanel(new MigLayout("", "[grow]", "[grow][][]"));
        panel.add((Component)this.tbpMain, "grow, wrap");
        panel.add((Component)new JSeparator(), "grow, wrap");
        panel.add((Component)pnlBottom, "grow");
        this.setContentPane(panel);
        this.setTitle("BSPSource 1.4.4");
        URL iconUrl = Objects.requireNonNull(this.getClass().getResource("icon.png"));
        Image icon = Toolkit.getDefaultToolkit().createImage(iconUrl);
        this.setIconImage(icon);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setDefaultCloseOperation(2);
    }

    private void initErrorDialog() {
        DialogAppender dialogAppender = DialogAppender.createAppender("DialogAppender" + this.hashCode(), new IsDecompileTaskFilter(Filter.Result.DENY, Filter.Result.NEUTRAL), null, false, this);
        final Log4jUtil.CloseableScope appenderCloseable = Log4jUtil.addAppenders(dialogAppender);
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosed(WindowEvent e) {
                appenderCloseable.close();
            }
        });
    }

    private void onDecompileTask(DecompileTaskModel model) {
        DecompileTaskDialog decompileTaskDialog = new DecompileTaskDialog((Window)this, model);
        decompileTaskDialog.setVisible(true);
    }

    private Path showSaveDialog(JFileChooser fileChooser) {
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            return fileChooser.getSelectedFile().toPath();
        }
        return null;
    }

    private void updateDecompileButton() {
        this.btnDecompile.setEnabled(!this.filesModel.getBspPaths().isEmpty());
    }
}

