/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui.panel;

import info.ata4.bspsrc.app.info.gui.data.GameLumpInfo;
import info.ata4.bspsrc.app.info.gui.models.BspInfoModel;
import info.ata4.bspsrc.app.info.gui.panel.LumpsPanel;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.app.util.swing.model.ReadonlyListTableModel;
import info.ata4.bspsrc.app.util.swing.renderer.ByteSizeCellRenderer;
import info.ata4.bspsrc.app.util.swing.renderer.ProgressCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GameLumpsPanel
extends JPanel {
    public final JTable tblLumps = new JTable();
    public final ReadonlyListTableModel<GameLumpInfo> tableModel = new ReadonlyListTableModel(List.of(new ReadonlyListTableModel.Column<GameLumpInfo, String>("Name", String.class, GameLumpInfo::name), new ReadonlyListTableModel.Column<GameLumpInfo, Integer>("Size", Integer.class, GameLumpInfo::size), new ReadonlyListTableModel.Column<GameLumpInfo, Integer>("Size usage", Integer.class, GameLumpInfo::sizePercentage), new ReadonlyListTableModel.Column<GameLumpInfo, Integer>("Version", Integer.class, GameLumpInfo::version)));
    public final JButton btnExtract = new JButton("Extract");
    public final JButton btnExtractAll = new JButton("Extract all");

    public GameLumpsPanel(Consumer<Set<Integer>> onExtractLumps) {
        this.setLayout(new BorderLayout());
        this.tblLumps.setModel(this.tableModel);
        this.tblLumps.setAutoCreateRowSorter(true);
        this.tblLumps.getColumnModel().getColumn(1).setCellRenderer(new ByteSizeCellRenderer());
        this.tblLumps.getColumnModel().getColumn(2).setCellRenderer(new ProgressCellRenderer());
        GuiUtil.setColumnWidth(this.tblLumps, 0, "----", false, false);
        GuiUtil.setColumnWidth(this.tblLumps, 1, 100100, true, false);
        GuiUtil.setColumnWidth(this.tblLumps, 2, 100, true, false);
        GuiUtil.setColumnWidth(this.tblLumps, 3, 10, true, false);
        JScrollPane scrlTable = new JScrollPane(this.tblLumps, 20, 31);
        this.add((Component)scrlTable, "Center");
        this.btnExtract.addActionListener(e -> {
            Set lumpIndices = Arrays.stream(this.tblLumps.getSelectedRows()).map(this.tblLumps::convertRowIndexToModel).boxed().collect(Collectors.toSet());
            if (!lumpIndices.isEmpty()) {
                onExtractLumps.accept(lumpIndices);
            }
        });
        this.btnExtractAll.addActionListener(e -> {
            Set lumpIndices = IntStream.range(0, this.tblLumps.getModel().getRowCount()).boxed().collect(Collectors.toSet());
            onExtractLumps.accept(lumpIndices);
        });
        JPanel pnlButtons = new JPanel(new FlowLayout(3));
        pnlButtons.add(this.btnExtract);
        pnlButtons.add(this.btnExtractAll);
        this.add((Component)pnlButtons, "South");
    }

    public void update(BspInfoModel model) {
        this.tableModel.setData(model.getGameLumps());
        boolean buttonsEnabled = !model.getGameLumps().isEmpty();
        this.btnExtract.setEnabled(buttonsEnabled);
        this.btnExtractAll.setEnabled(buttonsEnabled);
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new LumpsPanel(indices -> {}));
    }
}

