/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.app.info.gui.panel;

import info.ata4.bspsrc.app.info.gui.data.EmbeddedInfo;
import info.ata4.bspsrc.app.info.gui.models.BspInfoModel;
import info.ata4.bspsrc.app.util.swing.GuiUtil;
import info.ata4.bspsrc.app.util.swing.model.ReadonlyListTableModel;
import info.ata4.bspsrc.app.util.swing.renderer.ByteSizeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class EmbeddedPanel
extends JPanel {
    public final JTable tblFiles = new JTable();
    public final ReadonlyListTableModel<EmbeddedInfo> tableModel = new ReadonlyListTableModel(List.of(new ReadonlyListTableModel.Column<EmbeddedInfo, String>("Name", String.class, EmbeddedInfo::name), new ReadonlyListTableModel.Column<EmbeddedInfo, Long>("Size", Long.class, EmbeddedInfo::size)));
    public final JButton btnExtract = new JButton("Extract");
    public final JButton btnExtractAll = new JButton("Extract all");
    public final JButton btnExtractRaw = new JButton("Extract raw Zip file");

    public EmbeddedPanel(Consumer<Set<Integer>> onExtractFiles, Runnable onExtractRaw) {
        this.setLayout(new BorderLayout());
        this.tblFiles.setModel(this.tableModel);
        this.tblFiles.setAutoCreateRowSorter(true);
        this.tblFiles.getColumnModel().getColumn(1).setCellRenderer(new ByteSizeCellRenderer());
        GuiUtil.setColumnWidth(this.tblFiles, 0, "-".repeat(20), false, false);
        GuiUtil.setColumnWidth(this.tblFiles, 1, 100000, true, false);
        this.tblFiles.setPreferredScrollableViewportSize(new Dimension(this.tblFiles.getPreferredSize().width, -1));
        JScrollPane scrlTable = new JScrollPane(this.tblFiles, 20, 31);
        this.add((Component)scrlTable, "Center");
        this.btnExtract.addActionListener(e -> {
            Set fileIndices = Arrays.stream(this.tblFiles.getSelectedRows()).map(this.tblFiles::convertRowIndexToModel).boxed().collect(Collectors.toSet());
            if (!fileIndices.isEmpty()) {
                onExtractFiles.accept(fileIndices);
            }
        });
        this.btnExtractAll.addActionListener(e -> {
            Set fileIndices = IntStream.range(0, this.tblFiles.getModel().getRowCount()).boxed().collect(Collectors.toSet());
            onExtractFiles.accept(fileIndices);
        });
        this.btnExtractRaw.addActionListener(e -> onExtractRaw.run());
        JPanel pnlButtons = new JPanel(new FlowLayout(3));
        pnlButtons.add(this.btnExtract);
        pnlButtons.add(this.btnExtractAll);
        pnlButtons.add(this.btnExtractRaw);
        this.add((Component)pnlButtons, "South");
    }

    public void update(BspInfoModel model) {
        this.tableModel.setData(model.getEmbeddedInfos());
        boolean buttonsEnabled = !model.getEmbeddedInfos().isEmpty();
        this.btnExtract.setEnabled(buttonsEnabled);
        this.btnExtractAll.setEnabled(buttonsEnabled);
        this.btnExtractRaw.setEnabled(buttonsEnabled);
    }

    public static void main(String[] args) {
        GuiUtil.debugDisplay(() -> new EmbeddedPanel(indices -> {}, () -> {}));
    }
}

