/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer.source;

import info.ata4.io.buffer.source.ChannelSource;
import info.ata4.io.buffer.source.NonReadableSourceException;
import info.ata4.log.LogUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WritableByteChannelSource
extends ChannelSource<WritableByteChannel> {
    private static final Logger L = LogUtils.getLogger();

    public WritableByteChannelSource(ByteBuffer buf, WritableByteChannel chan) {
        super(buf, chan);
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean canGrow() {
        return true;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public void flush() throws IOException {
        this.buf.flip();
        int start = this.buf.position();
        while (((WritableByteChannel)this.chan).write(this.buf) > 0) {
        }
        L.log(Level.FINEST, "flush: {0} bytes written", this.buf.position() - start);
        this.buf.clear();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        throw new NonReadableSourceException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int n = this.chanBuf.write(src);
        if (n == -1) {
            L.finest("write: buffer full");
            this.flush();
            if (src.remaining() > this.buf.capacity()) {
                L.finest("write: write buffer directly");
                n = ((WritableByteChannel)this.chan).write(src);
            } else {
                n = this.chanBuf.write(src);
            }
        }
        return n;
    }

    @Override
    public ByteBuffer requestRead(int required) throws EOFException, IOException {
        throw new NonReadableSourceException();
    }

    @Override
    public ByteBuffer requestWrite(int required) throws EOFException, IOException {
        if (this.buf.remaining() < required) {
            this.flush();
            if (this.buf.remaining() < required) {
                throw new EOFException();
            }
        }
        return this.buf;
    }
}

