/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer.source;

import info.ata4.io.buffer.ByteBufferChannel;
import info.ata4.io.buffer.source.BufferedSource;
import info.ata4.io.buffer.source.NonSeekableSourceException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;

public abstract class ChannelSource<T extends Channel>
implements BufferedSource {
    protected final ByteBuffer buf;
    protected final T chan;
    protected final ByteBufferChannel chanBuf;

    public ChannelSource(ByteBuffer buf, T chan) {
        this.buf = buf;
        this.buf.limit(0);
        this.chan = chan;
        this.chanBuf = new ByteBufferChannel(buf);
    }

    @Override
    public void position(long newPos) throws IOException {
        throw new NonSeekableSourceException();
    }

    @Override
    public long position() throws IOException {
        throw new NonSeekableSourceException();
    }

    @Override
    public long size() throws IOException {
        throw new NonSeekableSourceException();
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public void order(ByteOrder order) {
        this.buf.order(order);
    }

    @Override
    public int bufferSize() {
        return this.buf.capacity();
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.chan.close();
    }
}

