/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer.source;

import info.ata4.io.buffer.source.BufferedSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;

public class BufferedSourceChannel
implements ByteChannel {
    private final BufferedSource buf;
    private boolean closed;

    public BufferedSourceChannel(BufferedSource buf) {
        this.buf = buf;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (!this.buf.canRead()) {
            throw new NonReadableChannelException();
        }
        return this.buf.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (!this.buf.canWrite()) {
            throw new NonWritableChannelException();
        }
        return this.buf.write(src);
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.buf.flush();
    }
}

