/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.lump;

import info.ata4.bspsrc.lib.BspFile;
import info.ata4.bspsrc.lib.lump.Lump;
import info.ata4.bspsrc.lib.lump.LumpException;
import info.ata4.bspsrc.lib.lump.LumpType;
import info.ata4.io.buffer.ByteBufferUtils;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LumpFile {
    private static final Logger L = LogManager.getLogger();
    public static final int HEADER_SIZE = 20;
    private Lump lump;
    private Path file;
    private int bspVersion;
    private int mapRev;

    public LumpFile(BspFile bsp) {
        this(bsp.getVersion());
        this.mapRev = bsp.getRevision();
    }

    public LumpFile(int bspVersion) {
        this.bspVersion = bspVersion;
    }

    public void load(Path file, ByteOrder bo) throws IOException {
        this.file = file;
        L.debug("Loading lump header from {}", (Object)file.getFileName());
        MappedByteBuffer bb = ByteBufferUtils.openReadOnly(file);
        bb.order(bo);
        if (bb.capacity() < 20) {
            throw new LumpException("Invalid or missing lump header");
        }
        int lumpOffset = bb.getInt();
        int lumpIndex = bb.getInt();
        int lumpVersion = bb.getInt();
        int lumpSize = bb.getInt();
        this.mapRev = bb.getInt();
        L.trace("Lump offset: {}", (Object)lumpOffset);
        L.trace("Lump ID: {}", (Object)lumpIndex);
        L.trace("Lump version: {}", (Object)lumpVersion);
        L.trace("Lump size: {}", (Object)lumpSize);
        L.trace("Map revision: {}", (Object)this.mapRev);
        if (lumpOffset != 20) {
            throw new LumpException("Unexpected lump offset: " + lumpOffset);
        }
        if (lumpIndex < 0 || lumpIndex > 64) {
            throw new LumpException("Invalid lump ID: " + lumpIndex);
        }
        if (lumpSize < 0 || lumpOffset > bb.limit()) {
            throw new LumpException("Invalid lump size: " + lumpOffset);
        }
        this.lump = new Lump(lumpIndex, LumpType.get(lumpIndex, this.bspVersion));
        this.lump.setBuffer(ByteBufferUtils.getSlice(bb, lumpOffset, lumpSize));
        this.lump.setOffset(lumpOffset);
        this.lump.setParentFile(file);
    }

    public void load(Path file) throws IOException {
        this.load(file, ByteOrder.LITTLE_ENDIAN);
    }

    public void save(Path file) throws IOException {
        if (this.lump == null) {
            throw new NullPointerException("Lump is undefined");
        }
        L.debug("Saving lump header to {}", (Object)file.getFileName());
        int size = 20 + this.lump.getLength();
        MappedByteBuffer bb = ByteBufferUtils.openReadWrite(file, 0, size);
        bb.order(this.lump.getBuffer().order());
        bb.putInt(20);
        bb.putInt(this.lump.getIndex());
        bb.putInt(this.lump.getVersion());
        bb.putInt(this.lump.getLength());
        bb.putInt(this.mapRev);
        L.debug("Saving lump data to {}", (Object)file.getFileName());
        bb.put(this.lump.getBuffer());
    }

    public Lump getLump() {
        return this.lump;
    }

    public void setLump(Lump lump) {
        this.lump = lump;
    }

    public Path getFile() {
        return this.file;
    }

    public int getMapRev() {
        return this.mapRev;
    }

    public void setMapRev(int mapRev) {
        this.mapRev = mapRev;
    }

    public int getBspVersion() {
        return this.bspVersion;
    }

    public void setBspVersion(int bspVersion) {
        this.bspVersion = bspVersion;
    }
}

