/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.io.lumpreader;

import info.ata4.bspsrc.lib.io.lumpreader.LumpReader;
import info.ata4.io.DataReader;
import info.ata4.io.DataReaders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TexdataStringLumpReader
implements LumpReader<List<String>> {
    private final List<Integer> stringTableIndices;

    public TexdataStringLumpReader(List<Integer> stringTableIndices) {
        this.stringTableIndices = Objects.requireNonNull(stringTableIndices);
    }

    @Override
    public List<String> read(ByteBuffer buffer) throws IOException {
        DataReader dataReader = DataReaders.forByteBuffer(buffer);
        ArrayList<String> texnames = new ArrayList<String>(this.stringTableIndices.size());
        for (int stringTableIndex : this.stringTableIndices) {
            dataReader.position(stringTableIndex);
            texnames.add(dataReader.readStringNull(Math.toIntExact(buffer.remaining())));
        }
        return texnames;
    }

    @Override
    public List<String> defaultData() {
        return Collections.emptyList();
    }
}

