/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.io.lumpreader;

import info.ata4.bspsrc.lib.entity.Entity;
import info.ata4.bspsrc.lib.io.EntityInputStream;
import info.ata4.bspsrc.lib.io.lumpreader.LumpReader;
import info.ata4.io.buffer.ByteBufferInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EntityLumpReader
implements LumpReader<List<Entity>> {
    private final boolean allowEscSeq;

    public EntityLumpReader(boolean allowEscSeq) {
        this.allowEscSeq = allowEscSeq;
    }

    @Override
    public List<Entity> read(ByteBuffer buffer) throws IOException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        try (ByteBufferInputStream in = new ByteBufferInputStream(buffer);
             EntityInputStream entReader = new EntityInputStream(in);){
            Entity ent;
            entReader.setAllowEscSeq(this.allowEscSeq);
            while ((ent = entReader.readEntity()) != null) {
                entities.add(ent);
            }
        }
        return entities;
    }

    @Override
    public List<Entity> defaultData() {
        return Collections.emptyList();
    }
}

