/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.io;

import info.ata4.bspsrc.lib.util.StringMacroUtils;
import info.ata4.io.buffer.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.LZMAOutputStream;

public class LzmaUtil {
    private static final Logger L = LogManager.getLogger();
    public static final int LZMA_ID = StringMacroUtils.makeID("LZMA");
    public static final int HEADER_SIZE = 17;

    private LzmaUtil() {
    }

    public static ByteBuffer uncompress(ByteBuffer buffer) throws IOException {
        ByteOrder bo = buffer.order();
        ByteBuffer bbc = buffer.duplicate();
        bbc.order(ByteOrder.LITTLE_ENDIAN);
        bbc.rewind();
        if (bbc.remaining() < 17 || bbc.getInt() != LZMA_ID) {
            throw new IOException("Buffer is not compressed");
        }
        int actualSize = bbc.getInt();
        int lzmaSize = bbc.getInt();
        byte probByte = bbc.get();
        int dictSize = bbc.getInt();
        int lzmaSizeBuf = bbc.limit() - 17;
        if (lzmaSizeBuf != lzmaSize) {
            L.warn("Difference in LZMA data length: found {} bytes, expected {}", (Object)lzmaSizeBuf, (Object)lzmaSize);
        }
        try (LZMAInputStream lzmaIn = new LZMAInputStream(new ByteBufferInputStream(bbc), actualSize, probByte, dictSize);){
            ByteBuffer byteBuffer = ByteBuffer.wrap(lzmaIn.readAllBytes()).order(bo);
            return byteBuffer;
        }
    }

    public static ByteBuffer compress(ByteBuffer buffer) throws IOException {
        int props;
        byte[] lzma;
        ByteOrder bo = buffer.order();
        ByteBuffer bbu = buffer.duplicate();
        bbu.rewind();
        LZMA2Options options = new LZMA2Options();
        try (ByteBufferInputStream bufferIn = new ByteBufferInputStream(bbu);
             ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
             LZMAOutputStream lzmaOut = new LZMAOutputStream((OutputStream)arrayOut, options, false);){
            bufferIn.transferTo(lzmaOut);
            lzma = arrayOut.toByteArray();
            props = lzmaOut.getProps();
        }
        int size = 17 + lzma.length;
        ByteBuffer bbc = ByteBuffer.allocateDirect(size);
        bbc.order(ByteOrder.LITTLE_ENDIAN);
        bbc.putInt(LZMA_ID);
        bbc.putInt(bbu.limit());
        bbc.putInt(lzma.length);
        bbc.put((byte)props);
        bbc.putInt(options.getDictSize());
        bbc.put(lzma);
        bbc.order(bo);
        bbc.rewind();
        return bbc;
    }

    public static boolean isCompressed(ByteBuffer buffer) {
        ByteBuffer bb = buffer.duplicate();
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.rewind();
        return bb.remaining() >= 17 && bb.getInt() == LZMA_ID;
    }

    public static LZMAInputStream fromZipEntry(InputStream rawInputStream, long uncompressedSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(rawInputStream.readNBytes(9)).order(ByteOrder.LITTLE_ENDIAN);
        byte majorVersion = buffer.get();
        byte minorVersion = buffer.get();
        int size = buffer.getShort() & 0xFFFF;
        if (size != 5) {
            L.warn(String.format("Unsupported lzma header size %ds. Version: %d.%d", size, (int)majorVersion, (int)minorVersion));
        }
        byte propByte = buffer.get();
        int dictSize = buffer.getInt();
        return new LZMAInputStream(rawInputStream, uncompressedSize, propByte, dictSize);
    }
}

