/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.io;

import info.ata4.bspsrc.common.util.CountingInputStream;
import info.ata4.bspsrc.lib.entity.Entity;
import info.ata4.bspsrc.lib.entity.KeyValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityInputStream
implements AutoCloseable {
    private static final Logger L = LogManager.getLogger();
    private final CountingInputStream in;
    private boolean allowEsc = false;

    public EntityInputStream(InputStream in) {
        this.in = Objects.requireNonNull(in) instanceof CountingInputStream ? (CountingInputStream)in : new CountingInputStream(in);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity readEntity() throws IOException {
        boolean section = false;
        boolean string = false;
        boolean esc = false;
        StringBuilder sb = new StringBuilder(512);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        String key = null;
        try {
            int b = 0;
            while (b != -1) {
                block20: {
                    switch (b) {
                        case 34: {
                            if (!section) {
                                throw new ParseException("String in unopened section");
                            }
                            if (esc) {
                                esc = false;
                                break;
                            }
                            if (string) {
                                if (key == null) {
                                    key = sb.toString();
                                } else {
                                    String value = sb.toString();
                                    if (key.isEmpty()) {
                                        L.debug("Skipped value \"{}\" with empty key at {}", (Object)value, (Object)this.in.getBytesRead());
                                    } else {
                                        keyValues.add(new KeyValue(key, value));
                                    }
                                    key = null;
                                }
                                sb.delete(0, sb.length());
                            }
                            string = !string;
                            break block20;
                        }
                        case 123: {
                            if (section && !string) {
                                throw new ParseException("Opened unclosed section");
                            }
                            if (string) break;
                            section = true;
                            break;
                        }
                        case 125: {
                            if (!section && !string) {
                                throw new ParseException("Closed unopened section");
                            }
                            if (string) break;
                            return new Entity(keyValues);
                        }
                        case 92: {
                            if (!this.allowEsc) break;
                            esc = true;
                        }
                    }
                    if (section && string) {
                        sb.append((char)b);
                    }
                }
                b = this.in.read();
            }
            return null;
        }
        catch (ParseException ex) {
            L.warn(String.format("%s at %d", ex.message, this.in.getBytesRead()));
            int b = 0;
            while (b != -1 && b != 125) {
                b = this.in.read();
            }
            return new Entity(keyValues);
        }
    }

    public boolean isAllowEscSeq() {
        return this.allowEsc;
    }

    public void setAllowEscSeq(boolean allowEsc) {
        this.allowEsc = allowEsc;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private static class ParseException
    extends Exception {
        private final String message;

        public ParseException(String message) {
            this.message = message;
        }
    }
}

