/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.io;

import info.ata4.bspsrc.lib.struct.DStruct;
import info.ata4.io.DataReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DataReaderUtil {
    public static <E> List<E> readChunks(DataReader reader, ChunkReader<E> chunkReader, int count) throws IOException {
        ArrayList<E> chunks = new ArrayList<E>(count);
        for (int i = 0; i < count; ++i) {
            E chunk = chunkReader.read(reader);
            chunks.add(chunk);
        }
        return chunks;
    }

    public static <T extends DStruct> T readDStruct(DataReader reader, T dStruct) throws IOException {
        long position = reader.position();
        dStruct.read(reader);
        if (reader.position() - position != (long)dStruct.getSize()) {
            throw new IOException(String.format("DStruct '%s' bytes read: %d; expected: %d", dStruct.getClass().getSimpleName(), position, dStruct.getSize()));
        }
        return dStruct;
    }

    @FunctionalInterface
    public static interface ChunkReader<T> {
        public T read(DataReader var1) throws IOException;
    }
}

