/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.lib.app;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SourceApp {
    private static final Logger L = LogManager.getLogger();
    private final String name;
    private final int appId;
    private final int versionMin;
    private final int versionMax;
    private final Pattern filePattern;
    private final Set<String> entities;
    private final float pointsEntities;
    private final float pointsFilePattern;

    SourceApp(String name, int appId, int versionMin, int versionMax, Pattern filePattern, Set<String> entities, float pointsEntities, float pointsFilePattern) {
        this.name = Objects.requireNonNull(name);
        this.appId = appId;
        this.versionMin = versionMin;
        this.versionMax = versionMax;
        this.filePattern = filePattern;
        this.entities = Set.copyOf(entities);
        this.pointsEntities = pointsEntities;
        this.pointsFilePattern = pointsFilePattern;
    }

    public String getName() {
        return this.name;
    }

    public int getAppId() {
        return this.appId;
    }

    public int getVersionMin() {
        return this.versionMin;
    }

    public int getVersionMax() {
        return this.versionMax;
    }

    public Pattern getFilePattern() {
        return this.filePattern;
    }

    public Set<String> getEntities() {
        return this.entities;
    }

    public float getPointsEntities() {
        return this.pointsEntities;
    }

    public float getPointsFilePattern() {
        return this.pointsFilePattern;
    }

    public Optional<Boolean> checkName(String name) {
        if (this.filePattern == null) {
            return Optional.empty();
        }
        return Optional.of(this.filePattern.matcher(name.toLowerCase(Locale.ROOT)).find());
    }

    public Optional<Boolean> checkVersion(int bspVersion) {
        if (this.versionMin == -1 && this.versionMax == -1) {
            return Optional.empty();
        }
        return Optional.of(!(this.versionMin != -1 && bspVersion < this.versionMin || this.versionMax != -1 && bspVersion > this.versionMax));
    }

    public Optional<Float> checkEntities(Set<String> classNames) {
        if (this.entities.isEmpty()) {
            return Optional.empty();
        }
        long matches = classNames.stream().filter(this.entities::contains).peek(s -> L.trace("Entity match: {}", s)).count();
        return Optional.of(Float.valueOf((float)matches / (float)this.entities.size()));
    }

    public String toString() {
        return "SourceApp{name='" + this.name + "', appId=" + this.appId + ", versionMin=" + this.versionMin + ", versionMax=" + this.versionMax + ", filePattern=" + String.valueOf(this.filePattern) + ", entities=" + String.valueOf(this.entities) + ", pointsEntities=" + this.pointsEntities + ", pointsFilePattern=" + this.pointsFilePattern + "}";
    }
}

