/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.util;

import info.ata4.bspsrc.lib.vector.Vector2f;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ConvexPolygon
extends AbstractList<Vector2f> {
    public final Vector2f[] vertices;
    public final Line[] edges;

    public ConvexPolygon(List<Vector2f> list) {
        this(list.toArray(new Vector2f[0]));
    }

    public ConvexPolygon(Vector2f ... vertices) {
        if (vertices.length < 3) {
            throw new IllegalArgumentException("Vertices array must have at least 3 vertices");
        }
        this.vertices = (Vector2f[])vertices.clone();
        this.edges = (Line[])IntStream.range(0, vertices.length).mapToObj(i -> new Line(vertices[i], vertices[(i + 1) % vertices.length])).toArray(Line[]::new);
        assert (this.verifyConvex()) : "Provided vertices don't create convex polygon: " + Arrays.toString(vertices);
    }

    private boolean verifyConvex() {
        return Arrays.stream(this.edges).flatMap(edge -> Arrays.stream(this.vertices).map(vertex -> Float.valueOf(edge.getDirectionVector().cross(vertex.sub(edge.start)))).filter(cross -> cross.floatValue() != 0.0f).map(cross -> cross.floatValue() > 0.0f)).distinct().limit(2L).count() <= 1L;
    }

    public Optional<ConvexPolygon> getIntersectionPolygon(ConvexPolygon polygon) {
        HashSet<Vector2f> intersectingVertices = new HashSet<Vector2f>();
        intersectingVertices.addAll(this.stream().filter(polygon::containsPosition).collect(Collectors.toList()));
        intersectingVertices.addAll(polygon.stream().filter(this::containsPosition).collect(Collectors.toList()));
        intersectingVertices.addAll(this.getIntersectionVertices(polygon));
        if (intersectingVertices.size() < 3) {
            return Optional.empty();
        }
        return Optional.of(ConvexPolygon.fromUnorderedVertices(intersectingVertices));
    }

    public Set<Vector2f> getIntersectionVertices(ConvexPolygon polygon) {
        return Arrays.stream(this.edges).flatMap(edge -> Arrays.stream(polygon.edges).flatMap(otherEdge -> edge.getIntersectionPoint((Line)otherEdge).stream())).collect(Collectors.toSet());
    }

    public boolean containsPosition(Vector2f position) {
        return Arrays.stream(this.edges).map(edge -> Float.valueOf(edge.getDirectionVector().cross(position.sub(edge.start)))).filter(cross -> cross.floatValue() != 0.0f).map(cross -> cross.floatValue() > 0.0f).distinct().limit(2L).count() <= 1L;
    }

    public float getArea() {
        return (float)Math.abs(Arrays.stream(this.edges).mapToDouble(edge -> edge.start.cross(edge.end)).sum() / 2.0);
    }

    @Override
    public Vector2f get(int index) {
        return this.vertices[index];
    }

    @Override
    public int size() {
        return this.vertices.length;
    }

    public static ConvexPolygon fromUnorderedVertices(Collection<Vector2f> vertices) {
        Vector2f midPoint = vertices.stream().reduce((vertex1, vertex2) -> vertex1.add((Vector2f)vertex2).scalar(0.5f)).orElse(Vector2f.NULL);
        return new ConvexPolygon((Vector2f[])vertices.stream().sorted(Comparator.comparingDouble(vertex -> Math.atan2(vertex.x - midPoint.x, vertex.y - midPoint.y))).toArray(Vector2f[]::new));
    }

    private static class Line {
        public final Vector2f start;
        public final Vector2f end;

        public Line(Vector2f start, Vector2f end) {
            this.start = Objects.requireNonNull(start);
            this.end = Objects.requireNonNull(end);
        }

        public Vector2f getDirectionVector() {
            return this.end.sub(this.start);
        }

        public Optional<Vector2f> getIntersectionPoint(Line otherLine) {
            Vector2f cmP = otherLine.start.sub(this.start);
            Vector2f r = this.getDirectionVector();
            Vector2f s = otherLine.getDirectionVector();
            float cmPxr = cmP.cross(r);
            float cmPxs = cmP.cross(s);
            float rxs = r.cross(s);
            if (rxs == 0.0f) {
                return Optional.empty();
            }
            float t = cmPxs / rxs;
            float u = cmPxr / rxs;
            if (t >= 0.0f && t <= 1.0f && u >= 0.0f && u <= 1.0f) {
                return Optional.of(this.start.add(r.scalar(t)));
            }
            return Optional.empty();
        }
    }
}

