/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.bspsrc.decompiler.util;

import info.ata4.bspsrc.lib.struct.BspData;
import info.ata4.bspsrc.lib.struct.DLeaf;

public class BspTreeStats {
    private BspData bsp;
    private int bmin;
    private int bmax;
    private int fmin;
    private int fmax;
    private int nmax;

    public BspTreeStats(BspData bsp) {
        this.bsp = bsp;
        this.reset();
    }

    public final void reset() {
        this.bmin = Integer.MAX_VALUE;
        this.bmax = -1;
        this.fmin = Integer.MAX_VALUE;
        this.fmax = -1;
        this.nmax = -1;
    }

    public void walk(int inode) {
        if (inode < 0) {
            int i;
            int ileaf = -1 - inode;
            DLeaf l = this.bsp.leaves.get(ileaf);
            for (i = 0; i < l.numleafface; ++i) {
                int iface = this.bsp.leafFaces.get(l.fstleafface + i);
                this.fmax = Math.max(this.fmax, iface);
                this.fmin = Math.min(this.fmin, iface);
            }
            for (i = 0; i < l.numleafbrush; ++i) {
                int ibrush = this.bsp.leafBrushes.get(l.fstleafbrush + i);
                this.bmax = Math.max(this.bmax, ibrush);
                this.bmin = Math.min(this.bmin, ibrush);
            }
        } else {
            this.nmax = Math.max(this.nmax, inode);
            this.walk(this.bsp.nodes.get((int)inode).children[0]);
            this.walk(this.bsp.nodes.get((int)inode).children[1]);
        }
    }

    public int getMinBrushLeaf() {
        return this.bmin;
    }

    public int getMaxBrushLeaf() {
        return this.bmax;
    }

    public int getMinFaceLeaf() {
        return this.fmin;
    }

    public int getMaxFaceLeaf() {
        return this.fmax;
    }

    public int getMaxNode() {
        return this.nmax;
    }
}

